/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasVisibility;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.container.presentation.client.EntityMemberClientService;
import de.justsoftware.onx.container.presentation.client.presenter.InformationTabAdminPresenter;
import de.justsoftware.onx.container.presentation.client.ui.EntityInformationAdminData;
import de.justsoftware.onx.container.presentation.client.ui.EntityTabClientFactory;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.logging.client.ClientLogger;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InformationTabAdminPresenter
implements EntityInformationAdminData.Presenter {
    private static final EntityMembershipToTeaser TO_TEASER = new EntityMembershipToTeaser();
    private final ClientLogger _logger;
    private final EntityMemberClientService _memberClientService;
    private final EntityTabClientFactory.EntityTabAdminPersonTeasersView _adminView;
    private final EntityTabClientFactory.EntityTabAdminPersonTeasersView _coAdminsView;
    private final EntityTabClientFactory.EntityTabAdminPersonTeasersView _inheritedCoAdminsView;
    private final EntityId _entityId;
    private final List<HasVisibility> _adminRows = Lists.newArrayList();
    private final List<HasVisibility> _coAdminRows = Lists.newArrayList();
    private final List<HasVisibility> _inheritedCoAdminRows = Lists.newArrayList();
    private boolean _hasAdmins = false;
    private boolean _hasCoAdmins = false;
    private boolean _hasInheritedCoAdmins = false;

    public InformationTabAdminPresenter(EntityId entityId, ClientFactory clientFactory) {
        this._logger = clientFactory.clientLogger();
        this._memberClientService = clientFactory.entityMemberClientFactory().clientService();
        this._adminView = clientFactory.entityTabClientFactory().createAdminPersonTeasersView();
        this._coAdminsView = clientFactory.entityTabClientFactory().createAdminPersonTeasersView();
        this._inheritedCoAdminsView = clientFactory.entityTabClientFactory().createAdminPersonTeasersView();
        this._entityId = entityId;
        this.clearTeasers();
    }

    public EntityTabClientFactory.EntityTabAdminPersonTeasersView getAdminView() {
        return this._adminView;
    }

    public EntityTabClientFactory.EntityTabAdminPersonTeasersView getCoAdminView() {
        return this._coAdminsView;
    }

    public EntityTabClientFactory.EntityTabAdminPersonTeasersView getInheritedCoAdminView() {
        return this._inheritedCoAdminsView;
    }

    public void update() {
        this._memberClientService.getAllEntityAdmins(this._entityId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void clearTeasers() {
        ImmutableList noAdmins = ImmutableList.of();
        this.updateTeaser(noAdmins, noAdmins, noAdmins);
    }

    protected void updateTeaser(ImmutableList<PersonTeaserModel> admins, ImmutableList<PersonTeaserModel> coAdmins, ImmutableList<PersonTeaserModel> inheritedCoAdmins) {
        this._hasAdmins = admins.size() > 0;
        this._adminView.setData(admins);
        this._hasCoAdmins = coAdmins.size() > 0;
        this._coAdminsView.setData(coAdmins);
        this._hasInheritedCoAdmins = inheritedCoAdmins.size() > 0;
        this._inheritedCoAdminsView.setData(inheritedCoAdmins);
        this.updateVisibility();
    }

    private void updateVisibility() {
        for (HasVisibility hv : this._adminRows) {
            hv.setVisible(this._hasAdmins);
        }
        for (HasVisibility hv : this._coAdminRows) {
            hv.setVisible(this._hasCoAdmins);
        }
        for (HasVisibility hv : this._inheritedCoAdminRows) {
            hv.setVisible(this._hasInheritedCoAdmins);
        }
    }

    public void handleVisibilityOfAdminRow(HasVisibility widget) {
        this._adminRows.add(widget);
        widget.setVisible(this._hasAdmins);
    }

    public void handleVisibilityOfCoAdminRow(HasVisibility widget) {
        this._coAdminRows.add(widget);
        widget.setVisible(this._hasCoAdmins);
    }

    public void handleVisibilityOfInheritedCoAdminRow(HasVisibility widget) {
        this._inheritedCoAdminRows.add(widget);
        widget.setVisible(this._hasInheritedCoAdmins);
    }
}

