/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.configuration;

import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import ro.isdc.wro.http.ConfigurableWroFilter;
import ro.isdc.wro.http.WroFilter;
import ro.isdc.wro.manager.factory.WroManagerFactory;

@Configuration
@ParametersAreNonnullByDefault
public class WroConfig {
    @Bean
    public FilterRegistrationBean<WroFilter> wroFilter(@Qualifier(value="wroProperties") PropertiesFactoryBean wroProperties, WroManagerFactory wroManagerFactory) throws IOException {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        ConfigurableWroFilter filter = new ConfigurableWroFilter();
        filter.setWroManagerFactory(wroManagerFactory);
        filter.setProperties(wroProperties.getObject());
        registrationBean.setFilter((Filter)filter);
        registrationBean.addUrlPatterns(new String[]{"/assets/*"});
        registrationBean.setOrder(2);
        return registrationBean;
    }

    @Bean
    @Qualifier(value="wroProperties")
    public PropertiesFactoryBean wroProperties(@Value(value="${wro.config.file}") Resource wroConfig) {
        PropertiesFactoryBean factoryBean = new PropertiesFactoryBean();
        factoryBean.setLocation(wroConfig);
        return factoryBean;
    }
}

