/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.overlay;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.comments.presentation.client.ui.CommentListWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceEditLabel;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceEditable;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.JCNavWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCPopupPanel;
import de.justsoftware.onx.common.presentation.client.ui.OptionsWidget;
import de.justsoftware.onx.common.presentation.client.ui.components.MediaCaption;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentDetailsWidget;
import de.justsoftware.onx.common.presentation.client.ui.overlay.EditableContentDetailsTypeSpecificWidget;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.JCMediaContent;
import de.justsoftware.onx.components.presentation.client.ui.ShowPopupUtils;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.presentation.client.presenter.LikePresenter;
import de.justsoftware.onx.like.presentation.client.ui.LikeView;
import de.justsoftware.onx.like.presentation.client.ui.LikeViewJoiner;
import de.justsoftware.onx.like.presentation.client.ui.LikeViewLink;
import de.justsoftware.onx.like.presentation.client.ui.RecentLikersView;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.shared.i18n.WorkstreamMessages;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContentDetailsWidget<T extends JCMediaContent<?>>
extends Composite {
    private static final ContentDetailsWidgetUiBinder UIBINDER = (ContentDetailsWidgetUiBinder)GWT.create(ContentDetailsWidgetUiBinder.class);
    private static final BasicConstants BASIC_CONSTANTS = I18nMediator.BASIC_CONSTANTS;
    @UiField
    FlowPanel _actionContainer;
    @UiField
    JCIconOnlyAnchor _optionsAnchor;
    @UiField
    HTMLPanel _commentsContainer;
    @UiField
    CommentListWidget _commentListWidget;
    @UiField
    SimplePanel _editableContentPanel;
    @UiField
    SimplePanel _infoPanel;
    @UiField
    MediaCaption _title;
    @UiField
    JCButton _saveButton;
    @UiField
    LikeViewLink _likeView;
    @UiField
    RecentLikersView _recentLikersView;
    @UiField
    Anchor _commentLink;
    @UiField
    JCIconOnlyAnchor _commentIcon;
    @UiField
    Panel _commentLinkPanel;
    private final List<InPlaceEditable> _editables = new ArrayList();
    private final OptionsWidget _menu = new OptionsWidget();
    private final JCPopupPanel _menuPopupPanel = new JCPopupPanel(true);
    private final LikePresenter _likePresenter;
    private final OnSave _onSave;
    private final ClientFactory _clientFactory;

    public ContentDetailsWidget(@Nonnull T content, @Nonnull InPlaceEditLabel title, @Nonnull OnSave onSave, @Nonnull EditableContentDetailsTypeSpecificWidget editableContent, @Nonnull Widget info, @Nonnull ClientFactory clientFactory) {
        this._onSave = onSave;
        this._clientFactory = clientFactory;
        this.initWidget((Widget)UIBINDER.createAndBindUi((Object)this));
        this._likePresenter = new LikePresenter(clientFactory, (LikeView)new LikeViewJoiner(new LikeView[]{this._likeView, this._recentLikersView}));
        this._likePresenter.setId((ItemId)content.getId());
        this._commentIcon.addStyleName("app-hover-color");
        if (content.mayComment()) {
            1 commentClickHandler = new /* Unavailable Anonymous Inner Class!! */;
            this._commentLink.addClickHandler((ClickHandler)commentClickHandler);
            this._commentIcon.addClickHandler((ClickHandler)commentClickHandler);
            this._commentLink.setVisible(true);
            this._commentIcon.setVisible(true);
        } else {
            this._commentLink.setVisible(false);
            this._commentIcon.setVisible(false);
        }
        this._commentListWidget.fillGUI(content);
        this._commentLinkPanel.setVisible(true);
        Image icon = new Image(ImageUrlUtil.getFullFileTypeImageUrl((String)content.getIconUrl()));
        this.setIcon(icon);
        this.setContentTitle(title);
        this.setSubtitle(content.getAuthor());
        this.setEditableContent(editableContent);
        this._infoPanel.setWidget(info);
        this.createOptionsPopover();
    }

    private boolean isEditable() {
        for (InPlaceEditable editable : this._editables) {
            if (!editable.isEditable()) continue;
            return true;
        }
        return false;
    }

    private void createOptionsPopover() {
        if (this.isEditable()) {
            this._menu.addLink(IconType.EDIT, BASIC_CONSTANTS.edit(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        this._menuPopupPanel.addAutoHidePartner((Element)this._optionsAnchor.getElement());
        this.updateOptionsAnchorVisibility();
    }

    public void resetOptionsPopover() {
        this.clearOptionLinks();
        this.createOptionsPopover();
    }

    private void updateOptionsAnchorVisibility() {
        this._optionsAnchor.setVisible(this._menu.getLinkCount() > 0);
    }

    @Nonnull
    public JCNavWidget addOptionsLink(@Nonnull IconType iconType, @Nonnull String text, @Nullable ClickHandler clickHandler) {
        JCNavWidget link = this._menu.addLink(iconType, text, clickHandler);
        link.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.updateOptionsAnchorVisibility();
        return link;
    }

    @Nonnull
    public JCNavWidget addOptionsLink(@Nonnull IconType iconType, @Nonnull String text) {
        return this.addOptionsLink(iconType, text, null);
    }

    public void clearOptionLinks() {
        this._menu.clearOptions();
        this.updateOptionsAnchorVisibility();
    }

    private void setIcon(@Nonnull Image icon) {
        this._title.setIcon((Widget)icon);
    }

    private void setContentTitle(@Nonnull InPlaceEditLabel title) {
        this._editables.add(title);
        this._title.setCaption((Widget)title);
    }

    @UiHandler(value={"_optionsAnchor"})
    public void toggleOptionsPopover(@Nullable ClickEvent event) {
        ShowPopupUtils.toggleRelativeTo((PopupPanel)this._menuPopupPanel, (Widget)this._menu, (Widget)this._optionsAnchor);
    }

    @UiHandler(value={"_saveButton"})
    public void saveTags(@Nullable ClickEvent event) {
        for (InPlaceEditable editable : this._editables) {
            editable.saveIfInEditMode();
        }
        this._saveButton.setVisible(false);
        this._onSave.onSave();
    }

    @UiFactory
    @Nonnull
    public BasicConstants createBasicConstants() {
        return I18nMediator.BASIC_CONSTANTS;
    }

    @UiFactory
    @Nonnull
    public WorkstreamMessages createWorkstreamMessages() {
        return I18nMediator.WORKSTREAM_MSG;
    }

    @UiFactory
    @Nonnull
    public CommentListWidget createCommentListWidget() {
        return new CommentListWidget(2, false, this._clientFactory);
    }

    @UiFactory
    @Nonnull
    RecentLikersView makeRecentLikersView() {
        return new RecentLikersView(this._clientFactory);
    }

    private void switchToEditMode() {
        for (InPlaceEditable editable : this._editables) {
            editable.switchToEditMode();
        }
        this._saveButton.setVisible(true);
    }

    public void setSubtitle(@Nullable PersonTeaserModel authorModel) {
        Label authorLink = authorModel == null ? new Label() : PersonUtil.profileLink((PersonTeaserModel)authorModel, (ClientFactory)this._clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP);
        this._title.setSubcaption((Widget)new InlineLabel(BASIC_CONSTANTS.from() + " "));
        this._title.addSubcaption((Widget)authorLink);
    }

    private void setEditableContent(@Nonnull EditableContentDetailsTypeSpecificWidget editableContent) {
        this._editableContentPanel.setWidget((Widget)editableContent);
        this._editables.addAll(editableContent.getEditables());
    }

    @Nonnull
    public JCIconOnlyAnchor getOptionsAnchor() {
        return this._optionsAnchor;
    }

    public void setCommentsCustomInfo(@Nonnull String customInfoDescription, @Nonnull String customInfo) {
        this._commentListWidget.setCustomInfoDescription(customInfoDescription);
        this._commentListWidget.setCustomInfo(customInfo);
    }
}

