/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.components;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.common.collect.ImmutableList;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InfoBoxWidget;
import de.justsoftware.onx.common.presentation.client.ui.JucoIconTypes;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidget;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidgetProvider;
import de.justsoftware.onx.common.presentation.client.ui.components.EntityChildListWidget;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.container.presentation.client.EntityChildrenMediator;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreatePopup;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.ChildEntityTeaserSortType;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTeaser;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.teasers.TeaserType;
import de.justsoftware.onx.searchnew.presentation.client.ClientSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityChildListWidget
extends Composite {
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private final InfoBoxWidget _infoBoxWidget;
    private final ClientFactory _clientFactory;

    public EntityChildListWidget(EntityId parentId, boolean showAddLink, EntityType childType, boolean simplePager, TeaserType teaserType, int numberOfTeasers, ChildEntityTeaserSortType childEntityTeaserSortOrder, @Nullable String customizedTitle, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        FlowPanel container = new FlowPanel();
        this._infoBoxWidget = new InfoBoxWidget();
        this.initWidget((Widget)this._infoBoxWidget);
        this._infoBoxWidget.setVisible(false);
        this._infoBoxWidget.setContent((Widget)container);
        SearchContext searchContext = SearchContext.ENTITY;
        String allToken = SearchHandler.tokenFor((SearchParameters)SearchHandler.parameters((FilterType)FilterTypes.getByEntityType((EntityType)childType), (SearchContext)searchContext, (EntityId)parentId).withChildEntityTeaserSortType(childEntityTeaserSortOrder).withDefaultSubfilter(ClientSearchConfigurationProvider.INSTANCE));
        String labelTitle = customizedTitle == null ? I18nMediator.getEntityConstantsByEntityType((EntityType)childType).childEntities(childType) : customizedTitle;
        this._infoBoxWidget.setLabel((Widget)new Hyperlink(labelTitle, allToken));
        this._infoBoxWidget.setTitle(labelTitle);
        if (showAddLink) {
            this._infoBoxWidget.addActionIcon(JucoIconTypes.ADD, e -> EntityCreatePopup.show((ClientFactory)this._clientFactory, (EntityType)childType, null, (String)"entity_children_module"), BASIC.add());
        }
        if (childEntityTeaserSortOrder != ChildEntityTeaserSortType.RANDOM) {
            PanelPagingWidget pager = this.getPager(childType, teaserType, numberOfTeasers, childEntityTeaserSortOrder, parentId);
            pager.setShowTopPager(false);
            pager.setSimplePager(simplePager);
            pager.setNoDataWidget(this.createNoDataWidget(showAddLink, childType, parentId));
            pager.update();
            container.add((Widget)pager);
        } else {
            EntityChildrenMediator.getInstance().getRandomChildrenTeasers(childType, parentId, teaserType, numberOfTeasers, ImmutableList.of((Object)ArchiveSubFilter.NON_ARCHIVED), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @Nonnull
    private PanelPagingWidget<EntityTeaser> getPager(EntityType childType, TeaserType teaserType, int numberOfTeasers, ChildEntityTeaserSortType childEntityTeaserSortOrder, EntityId parentEntityId) {
        EntityTeaserWidgetProvider pagingProvider = new EntityTeaserWidgetProvider(this, parentEntityId, teaserType, childEntityTeaserSortOrder, childType);
        return new PanelPagingWidget(numberOfTeasers, (Panel)new FlowPanel(), (PanelPagingWidgetProvider)pagingProvider);
    }

    @Nonnull
    private Widget createNoDataWidget(boolean mayAdd, EntityType childType, EntityId parentId) {
        EntityConstants entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)childType);
        if (mayAdd) {
            Anchor addLink = new Anchor(entityConstants.noChildEntitiesCreateOne(childType));
            addLink.addClickHandler(e -> EntityCreatePopup.show((ClientFactory)this._clientFactory, (EntityType)childType, null, (String)"entity_children_module"));
        }
        return new Label(entityConstants.noChildEntities(childType));
    }
}

