/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.google.gwt.user.datepicker.client.DatePicker;
import de.justsoftware.onx.common.presentation.client.ui.CompositePanelWithValue;
import de.justsoftware.onx.common.presentation.client.ui.TimestampBox;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.HostPropertiesBean;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimestampBox
extends CompositePanelWithValue<Date>
implements Validatable {
    protected static final com.freiheit.toro.common.shared.i18n.BasicConstants BASIC = I18nMediator.BASIC;
    protected static final BasicMessages BASIC_MESSAGES = I18nMediator.BASIC_MESSAGES;
    protected static final BasicConstants BASIC_CONST = I18nMediator.BASIC_CONSTANTS;
    protected final DateBox _date;
    protected final TimeTextBoxWithPopup _time;
    protected String _fieldName;
    protected boolean _mandatory;
    protected boolean _hasTime = true;
    private final Date _minDate;
    private final Date _maxDate;
    private final DateTimeFormat _dateFormat;
    private final DateTimeFormat _timeFormat;

    public TimestampBox() {
        this("");
    }

    public TimestampBox(@Nonnull String fieldname) {
        this(fieldname, false);
    }

    public TimestampBox(@Nonnull String fieldname, boolean mandatory) {
        super((Panel)new FlowPanel());
        this._fieldName = fieldname;
        this._dateFormat = DateTimeFormat.getFormat((String)BASIC.datumsFormat());
        this._timeFormat = DateTimeFormat.getFormat((String)BASIC.zeitFormat());
        this._date = new DateBox((DatePicker)new TimestampBoxDatePicker(), null, (DateBox.Format)new TimestampDateFormat(this._dateFormat));
        this._time = new TimeTextBoxWithPopup(this);
        this._time.setMaxLength(8);
        this._mandatory = mandatory;
        HostPropertiesBean props = HostPropertiesMediator.getHostPropertiesBean();
        this._minDate = this.getDateByYear(props.getSystemMinDateYear());
        this._maxDate = this.getDateByYear(props.getSystemMaxDateYear());
        this.add((Widget)this._date);
        this.add((Widget)this._time);
        this.setStyleName("timestampBox");
        this._date.setStyleName("gwt-TextBox");
        this._date.addStyleName("dateBox");
        this._time.addStyleName("timeBox");
        this._time.setVisible(this._hasTime);
        DateValueChangeHandler dateListener = new DateValueChangeHandler(this);
        this._date.addValueChangeHandler((ValueChangeHandler)dateListener);
        TextBox dateTextBox = this.getDateTextBox();
        if (dateTextBox != null) {
            dateTextBox.addBlurHandler((BlurHandler)dateListener);
        }
        TimeValueChangeHandler timeListener = new TimeValueChangeHandler(this);
        this._time.addValueChangeHandler((ValueChangeHandler)timeListener);
        this._time.addBlurHandler((BlurHandler)timeListener);
    }

    private Date getDateByYear(Integer year) {
        if (year == null) {
            return null;
        }
        Date result = new Date();
        result.setHours(0);
        result.setMinutes(0);
        result.setSeconds(0);
        result.setDate(1);
        result.setMonth(0);
        result.setYear(year - 1900);
        return result;
    }

    public void validate() throws ValidationException {
        Date timestamp = this.extractTimestamp();
        if (timestamp == null && this._mandatory) {
            throw new ValidationException(BASIC_MESSAGES.fillFieldx(this._fieldName));
        }
        if (timestamp != null && this._minDate != null && !timestamp.after(this._minDate) && (this._maxDate == null || timestamp.before(this._maxDate))) {
            String minDateString = this._dateFormat.format(this._minDate);
            String maxDateString = this._dateFormat.format(this._maxDate);
            throw new ValidationException(BASIC_MESSAGES.dateNotBetweenXAndY(this._fieldName, minDateString, maxDateString));
        }
    }

    @CheckForNull
    public Date extractTimestamp() throws ValidationException {
        return this._hasTime ? this.extractTimeAndDate() : this.extractJustDate();
    }

    @CheckForNull
    private Date extractTimeAndDate() throws ValidationException {
        Date result = new Date(0L);
        ValidationException error = null;
        try {
            Date date = this.extractJustDate();
            if (date == null) {
                return null;
            }
            result = new Date(date.getYear(), date.getMonth(), date.getDate());
        }
        catch (ValidationException e) {
            error = e;
        }
        try {
            Date time = this.extractJustTime();
            if (time != null) {
                result.setHours(time.getHours());
                result.setMinutes(time.getMinutes());
            } else {
                Date now = new Date();
                result.setHours(now.getHours());
                result.setMinutes(now.getMinutes());
            }
        }
        catch (ValidationException e) {
            ValidationException validationException = error = error != null ? e : new ValidationException(BASIC_MESSAGES.enteredDateAndTimeInvalid(this._fieldName));
        }
        if (error != null) {
            throw error;
        }
        return result;
    }

    @CheckForNull
    private Date extractJustTime() throws ValidationException {
        String timeAsText = this._time.getText();
        try {
            Date result;
            Date date = result = !StringUtil.isEmpty((String)timeAsText) ? this._timeFormat.parse(timeAsText) : null;
            if (result != null) {
                result.setDate(1);
                result.setMonth(0);
                result.setYear(-1900);
            }
            this.updateJustTime(result);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(BASIC_MESSAGES.enteredTimeInvalid(this._fieldName));
        }
    }

    @CheckForNull
    private Date extractJustDate() throws ValidationException {
        TextBox dateTextBox = this.getDateTextBox();
        String dateText = dateTextBox != null ? dateTextBox.getValue() : null;
        try {
            Date result;
            Date date = result = !StringUtil.isEmpty((String)dateText) ? this._dateFormat.parse(dateText) : null;
            if (result != null) {
                int year = 1900 + result.getYear();
                if (year < 1000 || year > 3000) {
                    throw new IllegalArgumentException("year is not between 1000 and 3000");
                }
                result.setHours(0);
                result.setMinutes(0);
                result.setSeconds(0);
            }
            this.updateJustDate(result);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(BASIC_MESSAGES.enteredDateInvalid(this._fieldName));
        }
    }

    private void updateFieldByTimestamp(@Nullable Date date) {
        this.updateJustDate(date);
        this.updateJustTime(date);
    }

    private void updateJustTime(@Nullable Date date) {
        if (date == null) {
            this.getTimeBox().setText("");
        } else {
            TimeTextBoxWithPopup timeBox = this.getTimeBox();
            if (timeBox != null) {
                timeBox.setValue((Object)this._timeFormat.format(date));
            }
        }
    }

    private void updateJustDate(@Nullable Date date) {
        TextBox dateTextBox = this.getDateTextBox();
        if (dateTextBox != null) {
            if (date == null) {
                dateTextBox.setValue((Object)"");
            } else {
                dateTextBox.setValue((Object)this._dateFormat.format(date));
            }
        }
    }

    public void setTimeEnabled(boolean enabled) {
        this._time.setEnabled(enabled);
    }

    public void setTimeVisible(boolean visible) {
        this._time.setVisible(visible);
    }

    public boolean isMandatory() {
        return this._mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this._mandatory = mandatory;
    }

    public void setValue(Date value, boolean fireEvents) {
        this.updateFieldByTimestamp(value);
        super.setValue((Object)value, fireEvents);
    }

    public Date getValue() {
        try {
            return this.extractTimestamp();
        }
        catch (ValidationException e) {
            return null;
        }
    }

    public void setHasTime(boolean hasTime) {
        this._hasTime = hasTime;
        this._time.setVisible(this._hasTime);
    }

    public boolean isHasTime() {
        return this._hasTime;
    }

    public void setEnabled(boolean enabled) {
        this._date.setEnabled(enabled);
        this._time.setEnabled(enabled);
        if (enabled) {
            this._date.removeStyleName("disabled");
            this._time.removeStyleName("disabled");
        } else {
            this._date.addStyleName("disabled");
            this._time.addStyleName("disabled");
        }
    }

    public DateBox getDateBox() {
        return this._date;
    }

    public TimeTextBoxWithPopup getTimeBox() {
        return this._time;
    }

    public void setFieldName(@Nonnull String fieldName) {
        this._fieldName = fieldName;
    }

    @Nonnull
    public String getFieldName() {
        return this._fieldName;
    }

    @CheckForNull
    private TextBox getDateTextBox() {
        return this._date != null ? this._date.getTextBox() : null;
    }

    public void addTextValueChangeHandler(@Nonnull ValueChangeHandler<String> handler) {
        TextBox dateTextBox = this.getDateTextBox();
        if (dateTextBox != null) {
            dateTextBox.addValueChangeHandler(handler);
        }
    }
}

