/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.common.collect.ImmutableMultimap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.BadgeActionResultPopup;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.presentation.client.ui.teasers.EntityOneLineTeaserWidget;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.FailedAndSuccessfulActions;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

public class BadgeActionResultPopup<T extends FailedAndSuccessfulActions<?>>
extends JCDialogBox {
    private static final BadgeActionResultPopupUIBinder UI_BINDER = (BadgeActionResultPopupUIBinder)GWT.create(BadgeActionResultPopupUIBinder.class);
    @UiField
    FlowPanel _successfulPanel;
    @UiField
    FlowPanel _errorsPanel;
    @UiField
    FlowPanel _successfulContent;
    @UiField
    FlowPanel _errorContent;
    private final EntityInfo _badge;
    private final T _actions;

    public BadgeActionResultPopup(@Nonnull T actions, @Nonnull EntityInfo badge) {
        super(false, true);
        this._actions = actions;
        this._badge = badge;
        this.setContent((IsWidget)UI_BINDER.createAndBindUi((Object)this));
        JCButton closeButton = new JCButton(I18nMediator.BASIC_CONSTANTS.close());
        this.addButton(closeButton);
        closeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void show() {
        super.show();
        this.displaySuccessfulActions();
        this.displayFailedActions();
        this.setSuccessfulContentVisibility();
    }

    private void displayFailedActions() {
        ImmutableMultimap errors = this._actions.getErrorMessages();
        this._errorsPanel.setVisible(!errors.isEmpty());
        for (Map.Entry entry : errors.asMap().entrySet()) {
            for (String message : (Collection)entry.getValue()) {
                FlowPanel container = new FlowPanel();
                container.add((Widget)new InlineLabel(message));
                this._errorContent.add((Widget)container);
            }
        }
    }

    @Nonnull
    protected T getActions() {
        return (T)this._actions;
    }

    protected void displaySuccessfulActions() {
        if (this._actions.getSuccessfullyProcessedObjects().contains(this._badge.getId())) {
            this.addSuccessfulContent((Widget)new EntityOneLineTeaserWidget(this._badge));
        }
    }

    private void setSuccessfulContentVisibility() {
        boolean visible = this._successfulContent.getWidgetCount() > 0;
        this._successfulPanel.setVisible(visible);
    }

    protected void addSuccessfulContent(@Nonnull Widget w) {
        this._successfulContent.add(w);
    }
}

