/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.presentation.client.ui;

import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.gwt.user.client.ui.MessageComposerDialogPresenter;
import de.justsoftware.gwt.user.client.ui.MessageComposerPresenter;
import de.justsoftware.onx.comments.presentation.client.ui.SingleCommentPresenter;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EditCommentPresenter
implements MessageComposerPresenter.ParentPresenter<GenericComment> {
    private final ClientFactory _clientFactory;
    private final SingleCommentPresenter _parent;
    private final MessageComposerDialogPresenter<GenericComment> _messageComposerDialogPresenter;
    private CommentId _commentId;
    private final MessageComposerPresenter<GenericComment> _composer;

    public EditCommentPresenter(ClientFactory clientFactory, SingleCommentPresenter parent) {
        this._clientFactory = clientFactory;
        this._parent = parent;
        this._messageComposerDialogPresenter = new MessageComposerDialogPresenter(clientFactory, (MessageComposerPresenter.ParentPresenter)this, clientFactory.localizedMessages().commentConstants().editCommentHeadline(), "");
        this._composer = this._messageComposerDialogPresenter.messageComposerPresenter();
        this._composer.setAutoHideSubmitPanel(false);
        this._composer.setSubmitButtonText(clientFactory.localizedMessages().basicConstants().save());
        this._composer.setCancelVisible(true);
    }

    public void show(GenericComment comment) {
        this._commentId = comment.getId();
        this._composer.setForbiddenTexts(ImmutableSet.of((Object)"", (Object)comment.getText()));
        this._messageComposerDialogPresenter.setTextAndShow(comment.getText());
    }

    public void onSubmit(String text, AsyncCallback<GenericComment> callback) {
        this._clientFactory.commentClientFactory().controller().editComment(this._commentId, text, callback);
    }

    public void onCancel() {
    }

    public void onSubmitFailure() {
    }

    public void onSubmitSuccess(GenericComment result) {
        this._parent.showComment(result);
    }
}

