/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.server;

import com.freiheit.toro.common.shared.i18n.AlbumMessages;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.justsoftware.gwt.i18n.dynamic.server.I18nMessagesFactory;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.presentation.shared.AlbumRemoteService;
import de.justsoftware.onx.album.shared.model.Album;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.Albums;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.album.shared.server.model.AlbumImageItem;
import de.justsoftware.onx.album.shared.server.model.AlbumItem;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.presentation.shared.model.ContentOverlayObject;
import de.justsoftware.onx.common.presentation.shared.model.ContentOverlayParent;
import de.justsoftware.onx.common.shared.i18n.I18nServiceException;
import de.justsoftware.onx.common.shared.model.JCMediaContent;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlbumRemoteServiceImpl
implements AlbumRemoteService {
    @Autowired
    private AlbumService _albumService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private WorkstreamService _workstreamService;
    @Autowired
    private ItemService _itemService;

    public Album getAlbumById(AlbumId albumId) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)albumId, (Action)StaticAction.ALBUM_READ);
        return this._albumService.getAlbumById(albumId, authorizationContext);
    }

    public Album getNoModuleAlbumByParentId(GlobalId parentId) {
        DBAlbum album;
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        try {
            album = this._albumService.getNoModuleDBAlbumByParentId(parentId);
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException();
        }
        authorizationContext.check((Item)new AlbumItem(album), (Action)StaticAction.ALBUM_READ);
        return this._albumService.getAlbumById(album.getId(), authorizationContext);
    }

    public Albums getAlbumsByParentId(GlobalId itemId) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        try {
            Item item = this._itemService.getByIdNonNull((ItemId)itemId);
            authorizationContext.check(item, (Action)StaticAction.ALBUM_READ);
            return this._albumService.getAlbumsByParentId(item, (AuthorizationCheckContextWithLocale)authorizationContext);
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException();
        }
    }

    public ListAndCount<Album> getAlbumListByParentId(GlobalId itemId, int offset, int limit) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)itemId, (Action)StaticAction.ALBUM_READ);
        return this._albumService.getAlbumListByParentId(itemId, offset, limit, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public AlbumId insertAlbum(DBAlbum album) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)album.getParentId(), (Action)StaticAction.ALBUM_CREATE);
        album.setModule(true);
        album.setOwnerId(authorizationContext.getUserId());
        return this._albumService.insertDBAlbum(album, true);
    }

    public ContentOverlayObject<AlbumImage> getImageById(AlbumImageId imageId, ContentOverlayParent contentOverlayParent) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)imageId, (Action)StaticAction.ALBUM_READ);
        AlbumImage result = this._albumService.getImageById(imageId, (AuthorizationCheckContextWithLocale)authorizationContext);
        if (result == null) {
            return null;
        }
        List ids = (List)contentOverlayParent.accept(() -> {
            ImmutableList images = this._albumService.getImagesByAlbumId(result.getAlbumId());
            return Lists.transform((List)images, (Function)DBAlbumImage.TO_ID);
        });
        return new ContentOverlayObject((JCMediaContent)result, ids);
    }

    public ListAndCount<AlbumImage> getImageListByAlbumId(AlbumId albumId, int offset, int limit) {
        Album album = this.getAlbumById(albumId);
        if (album == null) {
            throw new InvalidIdServiceException();
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new AlbumItem((DBAlbum)album), (Action)StaticAction.ALBUM_READ);
        return this._albumService.getImageListByAlbumId(albumId, offset, limit, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public void updateAlbumTitle(AlbumId id, String title) {
        DBAlbum album = (DBAlbum)InvalidIdServiceException.check((Object)this._albumService.getDBAlbumById(id));
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new AlbumItem(album), (Action)StaticAction.ALBUM_UPDATE);
        this._albumService.updateAlbumTitle(album, title);
    }

    public void updateAlbumLocation(AlbumId id, String location) {
        DBAlbum album = (DBAlbum)InvalidIdServiceException.check((Object)this._albumService.getDBAlbumById(id));
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new AlbumItem(album), (Action)StaticAction.ALBUM_UPDATE);
        this._albumService.updateAlbumLocation(album, location);
    }

    public void updateAlbumDescription(AlbumId id, String description) {
        DBAlbum album = (DBAlbum)InvalidIdServiceException.check((Object)this._albumService.getDBAlbumById(id));
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((Item)new AlbumItem(album), (Action)StaticAction.ALBUM_UPDATE);
        this._albumService.updateAlbumDescription(album, description);
    }

    public void updateImageTitle(AlbumImageId imageId, String title) {
        DBAlbumImage image = (DBAlbumImage)InvalidIdServiceException.check((Object)this._albumService.getDBImageById(imageId));
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((Item)AlbumImageItem.of((DBAlbumImage)image), (Action)StaticAction.ALBUM_UPDATE);
        if (title != null && title.length() > 255) {
            I18nMessagesFactory factory = new I18nMessagesFactory();
            throw new I18nServiceException(factory.getMessage(((AlbumMessages)factory.createProxy(AlbumMessages.class)).titleExceedMaximumLength(255)));
        }
        image.setTitle(title);
        this._albumService.updateDBImage(image);
    }

    public void deleteImage(AlbumImageId imageId) {
        this._albumService.deleteDBImage(imageId, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public void deleteImages(List<AlbumImageId> imageIds) {
        for (AlbumImageId id : imageIds) {
            this.deleteImage(id);
        }
    }

    public void deleteAlbum(AlbumId albumId) {
        this._albumService.deleteDBAlbum(albumId, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public int getPostitionOfImage(AlbumImageId id) {
        DBAlbumImage image = this._albumService.getDBImageById(id);
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        if (image == null) {
            return -1;
        }
        authorizationContext.check((Item)AlbumImageItem.of((DBAlbumImage)image), (Action)StaticAction.ALBUM_READ);
        ImmutableList images = this._albumService.getImagesByAlbumId(image.getAlbumId());
        for (int i = 0; i < images.size(); ++i) {
            if (!((DBAlbumImage)images.get(i)).getId().equals((Object)id)) continue;
            return i;
        }
        return -1;
    }
}

