/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server.resource;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.i18n.BasicMessages;
import com.freiheit.toro.server.UrlBuilder;
import com.freiheit.toro.server.resource.HtmlScaffoldServlet;
import com.freiheit.toro.server.resource.StartConfiguration;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import de.justsoftware.context.api.business.JustContextService;
import de.justsoftware.context.api.model.JustContext;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.UserCoreAppConfig;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.presentation.shared.config.OptionalEntityIdStartConfigurationField;
import de.justsoftware.onx.common.presentation.shared.config.StartConfigurationField;
import de.justsoftware.onx.common.presentation.shared.config.StringStartConfigurationField;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.shared.model.StaticWebResource;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.design.shared.model.ThemeWebResource;
import de.justsoftware.onx.design.shared.model.WebResource;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.server.i18n.I18nServlet;
import de.justsoftware.web.design.WebResourceHandler;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.gwtwidgets.server.spring.ServletUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

@Service(value="htmlScaffoldServlet")
public class HtmlScaffoldServlet
implements Controller,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlScaffoldServlet.class);
    private static final String SERVLET_PATH = "html";
    private static final String CUSTOMER_JAVASCRIPT_FILE = "custom.js";
    private static final String JUST_AUTHENTICATION_URL = "/authentication/adfs/authenticate";
    private static final String HOLMES_ANALYTICS_URI = "/holmes/analytics.js";
    private final String REACT_MODE = "react-mode";
    private final String REACT_DEV = "development";
    private final String REACT_PROD = "production";
    private final String _imageServerUrl;
    private final Settings _settings;
    private final String _version;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private ServerUrlUtil _serverUrlUtil;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private I18nServlet _i18nServlet;
    @Autowired
    private PersonService _personService;
    @Autowired
    private FrontendLoginService _loginService;
    @Autowired
    private WebResourceHandler _webResourceHandler;
    @Autowired
    private ThemeService _themeService;
    @Autowired
    private LocaleResolver _localeResolver;
    @Value(value="${just.client.libs.path}")
    private String _justClientLibsPath;
    @Value(value="${just-drive.app.url}")
    private String _driveAppUrl;
    @Value(value="${just-tasks.app.url}")
    private String _tasksAppUrl;
    @Value(value="${just.client.components.lib.url}")
    private String _justClientComponentsLib;
    @Value(value="${just-context.libs.url}")
    private String _justContextLib;
    @Value(value="${just-entity.app.url}")
    private String _entityAppUrl;
    @Value(value="${just-search.libs.url}")
    private String _justSearchLib;
    @Value(value="${just-notification.libs.url:/notification/bundles/notification.bundle.js}")
    private String _justNotificationLib;
    @Value(value="${just-people.app.url:/people/bundles/people.bundle.js}")
    private String _peopleAppUrl;
    @Value(value="${just-news.app.url:/news/bundles/news.bundle.js}")
    private String _newsAppUrl;
    @Value(value="${just-archivednews.app.url:/archivednews/bundles/archivednews.bundle.js}")
    private String _archivedNewsAppUrl;
    @Value(value="${just-wiki.app.url:/wiki/bundles/wiki.bundle.js}")
    private String _wikiAppUrl;
    @Value(value="${just-chat.app.url:/chat/bundles/chat.bundle.js}")
    private String _chatAppUrl;
    @Value(value="${just-admin.app.url:/admin/bundles/admin.bundle.js}")
    private String _adminAppUrl;
    @Value(value="${just-connect.app.url:/connect/scripts/connect.js}")
    private String _connectAppUrl;
    @Value(value="${just-connect.libs.url:/connect/scripts/connect-libs.js}")
    private String _connectLibsUrl;
    @Value(value="${just-connect.css.url:/connect/styles/connect.css}")
    private String _connectCssUrl;
    @Autowired
    private JustContextService _justContextService;
    @Autowired
    private JucoObjectMapper _jucoObjectMapper;
    @Autowired
    private AppConfigService _appConfigService;
    private final boolean _collectRequests;
    private final boolean _profileRequests;

    @Autowired
    public HtmlScaffoldServlet(Settings settings, @Value(value="${imageServerUrl}") String imageServerUrl, @Value(value="${justconnect.version}") String version, @Value(value="${collectRequests:true}") boolean collectRequests, @Value(value="${profileRequests:false}") boolean profileRequests) {
        this._imageServerUrl = imageServerUrl;
        this._settings = settings;
        this._version = version;
        this._collectRequests = collectRequests;
        this._profileRequests = profileRequests;
    }

    public void afterPropertiesSet() {
        UrlBuilder.setProxyPort((int)this._serverUrlUtil.getSystemPort());
    }

    @Nonnull
    private String loadCustomerJavaScript() {
        try {
            URL url;
            try {
                url = Resources.getResource((String)CUSTOMER_JAVASCRIPT_FILE);
            }
            catch (IllegalArgumentException e) {
                return "";
            }
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Cold not load customer specific JavaScript", (Throwable)e);
            return "";
        }
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, TemplateException, JSONException {
        AuthorizationCheckContext anonymousCtx;
        ServletUtils.setResponse((HttpServletResponse)response);
        String reactMode = request.getParameter("react-mode");
        if (StringUtils.isNotBlank((String)reactMode)) {
            boolean setToProd;
            boolean setToDev = reactMode.equals("dev") || reactMode.equals("development");
            boolean bl = setToProd = reactMode.equals("prod") || reactMode.equals("production");
            if (setToDev) {
                response.addCookie(new Cookie("react-mode", "development"));
            } else if (setToProd) {
                response.addCookie(new Cookie("react-mode", "production"));
            }
        }
        if (StringUtils.isNotBlank((String)request.getParameter("logout"))) {
            this._loginService.logout(request, response);
            return this.redirect(request, response);
        }
        Optional<DBPerson> currentUser = Optional.ofNullable(SecurityUtils.getUserIdOrNull()).map(userId -> this._personService.getPersonById(userId));
        if (currentUser.map(DBPerson::getLanguageId).isPresent()) {
            this._localeResolver.setLocale(request, response, org.springframework.util.StringUtils.parseLocaleString((String)currentUser.get().getLanguageId()));
        }
        if (!(anonymousCtx = this._authorizationContextProvider.getAuthorizationCheckContextForLoggedInOrNotLoggedInUser()).isAuthenticatedUser()) {
            if (this._settings.isAdfsEnabled()) {
                return this.redirectToAdfs();
            }
            response.sendRedirect("/login");
            return null;
        }
        AuthorizationContext authCtx = anonymousCtx.asAuthorizationContext();
        PersonId userId2 = authCtx.getUserId();
        String locale = authCtx.getLocale();
        BasicConstants basicConst = (BasicConstants)this._i18nService.createProxy(BasicConstants.class, locale);
        Theme defaultTheme = this._themeService.getDefaultTheme();
        HashMap model = Maps.newHashMap();
        if (this._settings.isTermsAcceptanceRequired()) {
            DBPerson user;
            String loginCode = request.getParameter("acceptTerms");
            if (StringUtils.isNotBlank((String)loginCode)) {
                try {
                    this._personService.acceptTerms(userId2, loginCode);
                    return this.redirect(request, response);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if ((user = this._personService.getPersonById(userId2)) != null && !Boolean.TRUE.equals(user.getTermsAccepted())) {
                response.sendRedirect("/account/acceptTerms/" + this._personService.generateLoginCode(userId2));
                return null;
            }
        }
        BasicMessages basicMsg = (BasicMessages)this._i18nService.createProxy(BasicMessages.class, locale);
        StartConfiguration startConfig = new StartConfiguration();
        model.put("startConfig", startConfig);
        startConfig.set((StartConfigurationField)StringStartConfigurationField.IMAGE_SERVER_URL, (Object)this._imageServerUrl);
        model.put("loadingApplicationXPleaseWait", basicMsg.loadingApplicationXPleaseWait(this._settings.getDefaultSiteTitle()));
        model.put("htmlLoadingTextHint", basicConst.htmlLoadingTextHint());
        model.put("staticResourcePrefix", this._serverUrlUtil.getStaticResourcePrefix());
        model.put("dynamicResourcePrefix", this._serverUrlUtil.getDynamicResourcePrefix());
        model.put("defaultTitle", this._settings.getDefaultSiteTitle());
        startConfig.set((StartConfigurationField)StringStartConfigurationField.PAGE_TITLE_SUFFIX, (Object)this._settings.getDefaultSiteTitle());
        startConfig.set((StartConfigurationField)OptionalEntityIdStartConfigurationField.DOMAIN_ENTITY_ID, (Object)com.google.common.base.Optional.absent());
        model.put("locale", locale);
        model.put("hide", basicConst.hide());
        model.put("nocacheSuffix", "");
        startConfig.set((StartConfigurationField)StringStartConfigurationField.PLATFORM_VERSION, (Object)this._version);
        model.put("collectRequests", this._collectRequests);
        model.put("profileRequests", this._profileRequests);
        model.put("favIconUrl", this._settings.getFavIconUrl());
        model.put("favIconImageType", this._settings.getFavIconImageType());
        model.put("i18nParams", this.getI18nParams(request, locale));
        ThemeWebResource defaultThemeResource = ThemeWebResource.of((ThemeId)defaultTheme.getId());
        ImmutableSet.Builder cssResources = ImmutableSet.builder();
        cssResources.add((Object[])new WebResource[]{StaticWebResource.JUCO_MAIN_CSS, defaultThemeResource});
        ImmutableMap cssResourceMap = this._webResourceHandler.getCurrentResourceNames((Iterable)cssResources.build(), request, response);
        String mainCss = (String)cssResourceMap.get((Object)StaticWebResource.JUCO_MAIN_CSS);
        model.put("jucoDesignResource", mainCss);
        model.put("defaultThemeResource", defaultThemeResource);
        model.put("defaultThemeResourceUri", cssResourceMap.get((Object)defaultThemeResource));
        ImmutableSet.Builder cssFiles = ImmutableSet.builder().add((Object)(this._justClientLibsPath + "just-client-libs.bundle.css"));
        model.put("cssFiles", cssFiles.build());
        JustContext justContext = this._justContextService.getContext(authCtx);
        model.put("justContext", this._jucoObjectMapper.writeValueAsString((Object)justContext));
        ImmutableSet scriptFiles = this.getScriptFiles(request, response, authCtx);
        model.put("scriptFiles", scriptFiles);
        model.put("contextPath", request.getContextPath());
        startConfig.set((StartConfigurationField)StringStartConfigurationField.CUSTOMER_JAVA_SCRIPT, (Object)this.loadCustomerJavaScript());
        model.put("holmesAnalyticsURI", HOLMES_ANALYTICS_URI);
        model.put("piwikURL", this._settings.getPiwikUrl());
        model.put("piwikSiteId", this._settings.getPiwikSiteId());
        model.put("cookieBannerEnabled", this._settings.isCookieBannerEnabled());
        this.putEnabledFeatureToggles((Map)model);
        return this.renderJust(response, (Map)model);
    }

    @Nonnull
    private ImmutableSet<String> getScriptFiles(HttpServletRequest request, HttpServletResponse response, AuthorizationContext authCtx) {
        ImmutableSet.Builder scriptBuilder = ImmutableSet.builder();
        ImmutableSet jsResources = ImmutableSet.of((Object)StaticWebResource.LIBRARIES_JS);
        ImmutableMap jsResourceMap = this._webResourceHandler.getCurrentResourceNames((Iterable)jsResources, request, response);
        scriptBuilder.addAll((Iterable)jsResourceMap.values().stream().filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet()));
        if (StringUtils.isNotBlank((String)this._justClientLibsPath)) {
            String reactMode = this.getCookieValue(request, "react-mode");
            if (reactMode != null && reactMode.equals("development")) {
                scriptBuilder.add((Object)(this._justClientLibsPath + "just-client-libs.dev.bundle.js"));
            } else {
                scriptBuilder.add((Object)(this._justClientLibsPath + "just-client-libs.bundle.js"));
            }
        }
        if (StringUtils.isNotBlank((String)this._justClientComponentsLib)) {
            scriptBuilder.add((Object)this._justClientComponentsLib);
        }
        if (StringUtils.isNotBlank((String)this._justContextLib)) {
            scriptBuilder.add((Object)this._justContextLib);
        }
        if (StringUtils.isNotBlank((String)this._justSearchLib)) {
            scriptBuilder.add((Object)this._justSearchLib);
        }
        if (StringUtils.isNotBlank((String)this._justNotificationLib)) {
            scriptBuilder.add((Object)this._justNotificationLib);
        }
        if (StringUtils.isNotBlank((String)this._driveAppUrl)) {
            scriptBuilder.add((Object)this._driveAppUrl);
        }
        if (StringUtils.isNotBlank((String)this._peopleAppUrl)) {
            scriptBuilder.add((Object)this._peopleAppUrl);
        }
        ImmutableList availableAppIds = (ImmutableList)this._appConfigService.getAvailableAppConfigs(authCtx).stream().filter(app -> app instanceof UserCoreAppConfig).map(app -> (UserCoreAppConfig)app).collect(ImmutableList.toImmutableList());
        availableAppIds.forEach(app -> {
            switch (1.$SwitchMap$de$justsoftware$onx$appswitcher$shared$model$CoreApp[app.getApp().ordinal()]) {
                case 1: {
                    scriptBuilder.add((Object)this._chatAppUrl);
                    break;
                }
                case 2: {
                    scriptBuilder.add((Object)this._tasksAppUrl);
                    break;
                }
                case 3: {
                    scriptBuilder.add((Object)this._driveAppUrl);
                    break;
                }
                case 4: {
                    scriptBuilder.add((Object)this._peopleAppUrl);
                    break;
                }
                case 5: {
                    scriptBuilder.add((Object)this._newsAppUrl);
                    break;
                }
                case 6: {
                    scriptBuilder.add((Object)this._wikiAppUrl);
                    break;
                }
                case 7: {
                    scriptBuilder.add((Object)this._adminAppUrl);
                    break;
                }
                case 8: {
                    scriptBuilder.add((Object)this._archivedNewsAppUrl);
                    scriptBuilder.add((Object)this._entityAppUrl);
                    break;
                }
            }
        });
        return scriptBuilder.build();
    }

    private ModelAndView redirectToAdfs() {
        return new ModelAndView("redirect_to_adfs", (Map)ImmutableMap.of((Object)"justAuthenticationURL", (Object)JUST_AUTHENTICATION_URL, (Object)"favIconUrl", (Object)this._settings.getFavIconUrl(), (Object)"favIconImageType", (Object)this._settings.getFavIconImageType()));
    }

    private ModelAndView redirect(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        String token = request.getParameter("token");
        if (StringUtils.isNotBlank((String)token)) {
            response.sendRedirect("html#" + URLEncoder.encode(token, Charsets.UTF_8));
        } else {
            response.sendRedirect(this._serverUrlUtil.getSystemDomainPrefix());
        }
        return null;
    }

    private ModelAndView renderJust(HttpServletResponse response, Map<String, ?> model) {
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "max-age=0, no-store");
        response.setHeader("Vary", "User-Agent");
        return new ModelAndView("just", model);
    }

    @Nonnull
    private String getI18nParams(@Nonnull HttpServletRequest request, @Nullable String locale) {
        StringBuilder i18nParams = new StringBuilder();
        if (StringUtils.isNotBlank((String)locale)) {
            i18nParams.append("locale=").append(locale).append("&");
        }
        if ("true".equals(request.getParameter("displayPropertyKeys"))) {
            i18nParams.append("displayPropertyKeys=true").append("&");
        }
        i18nParams.append("hash=").append(this._i18nServlet.getCurrentHash());
        return i18nParams.toString();
    }

    private void putEnabledFeatureToggles(@Nonnull Map<String, Object> model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap featureToggle = builder.build();
        if (!featureToggle.isEmpty()) {
            model.put("featureToggleJson", new JSONObject((Map)featureToggle).toString());
        }
    }

    @CheckForNull
    private String getCookieValue(@Nonnull HttpServletRequest request, @Nonnull String name) {
        return Arrays.stream(request.getCookies()).filter(c -> c.getName().equals(name)).findFirst().map(Cookie::getValue).orElse(null);
    }
}

