/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence.h2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Table;
import de.justsoftware.permission.business.config.model.Replacement;
import de.justsoftware.permission.business.role.model.DirectlyResolvableRole;
import de.justsoftware.permission.business.role.model.ProfileRole;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.permission.persistence.DAOSupport;
import de.justsoftware.permission.persistence.RoleDAO;
import de.justsoftware.permission.persistence.SqlBuilder;
import de.justsoftware.permission.persistence.TransactionSupport;
import de.justsoftware.toolbox.ObjectUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@ParametersAreNonnullByDefault
public class H2RoleDAO
implements RoleDAO {
    private final DAOSupport _daoSupport;
    private final TransactionSupport _transactionSupport;
    private final JdbcTemplate _jdbcTemplate;

    @Autowired
    public H2RoleDAO(DAOSupport daoSupport, TransactionSupport transactionSupport, JdbcTemplate jdbcTemplate) {
        this._daoSupport = daoSupport;
        this._transactionSupport = transactionSupport;
        this._jdbcTemplate = jdbcTemplate;
    }

    public void storeRoleReplacements(Table<? extends DirectlyResolvableRole, Role, Boolean> replacements) {
        this._transactionSupport.doInTransaction(() -> {
            this._daoSupport.batchUpdate("DELETE FROM role_replacement WHERE role = ? AND replacement = ?", (Iterable)replacements.cellSet(), (Iterable)ImmutableList.of(cell -> ((DirectlyResolvableRole)ObjectUtil.checkNotNull((Object)((DirectlyResolvableRole)cell.getRowKey()))).name(), cell -> ((Role)ObjectUtil.checkNotNull((Object)((Role)cell.getColumnKey()))).name()));
            this._daoSupport.batchUpdate("INSERT INTO role_replacement(role, replacement, profile_replacement) VALUES(?,?,?)", replacements.cellSet().stream().filter(Table.Cell::getValue).toList(), (Iterable)ImmutableList.of(cell -> ((DirectlyResolvableRole)ObjectUtil.checkNotNull((Object)((DirectlyResolvableRole)cell.getRowKey()))).name(), cell -> ((Role)ObjectUtil.checkNotNull((Object)((Role)cell.getColumnKey()))).name(), cell -> ((Role)ObjectUtil.checkNotNull((Object)((Role)cell.getColumnKey()))).name().startsWith("PROFILE,")));
        });
    }

    public void replaceRoleReplacements(Map<? extends DirectlyResolvableRole, Replacement> replacements) {
        this._transactionSupport.doInTransaction(() -> {
            this._daoSupport.batchUpdate("DELETE FROM role_replacement WHERE role = ?", replacements.entrySet(), (Iterable)ImmutableList.of(e -> ((DirectlyResolvableRole)e.getKey()).name()));
            String sql = "INSERT INTO role_replacement(role, replacement, profile_replacement) VALUES(?,?,?)";
            LinkedList batchArgs = new LinkedList();
            replacements.forEach((role, replacement) -> replacement.getAllowed().forEach(value -> batchArgs.add(new Object[]{role.name(), value.name(), value.name().startsWith("PROFILE,")})));
            this._jdbcTemplate.batchUpdate("INSERT INTO role_replacement(role, replacement, profile_replacement) VALUES(?,?,?)", batchArgs);
        });
    }

    public ImmutableMap<DirectlyResolvableRole, Replacement> getReplacements(Set<? extends DirectlyResolvableRole> roles) {
        return this.getReplacementsInternal(roles, false);
    }

    public ImmutableMap<DirectlyResolvableRole, Replacement> getNonProfileReplacements(Set<? extends DirectlyResolvableRole> roles) {
        return this.getReplacementsInternal(roles, true);
    }

    @Nonnull
    private ImmutableMap<DirectlyResolvableRole, Replacement> getReplacementsInternal(Set<? extends DirectlyResolvableRole> roles, boolean filterProfiles) {
        ImmutableSetMultimap.Builder allowedRolesBuilder = ImmutableSetMultimap.builder();
        SqlBuilder sql = this._daoSupport.prep("SELECT role, replacement FROM role_replacement WHERE role = ANY (").appendParam((Object)roles.stream().map(Role::name).toArray()).append(") ", new Object[0]);
        if (filterProfiles) {
            sql.append("AND not profile_replacement", new Object[0]);
        }
        sql.set(rs -> allowedRolesBuilder.put((Object)H2RoleDAO.roleCol((ResultSet)rs), (Object)H2RoleDAO.replacementCol((ResultSet)rs)));
        ImmutableSetMultimap allowedRoles = allowedRolesBuilder.build();
        return (ImmutableMap)roles.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), r -> new Replacement((Set)allowedRoles.get(r))));
    }

    public ImmutableSetMultimap<Role, DirectlyResolvableRole> getInverseAllowedReplacements(Set<? extends Role> replacements) {
        return this._daoSupport.prep("SELECT role, replacement FROM role_replacement WHERE replacement = ANY (").appendParam((Object)replacements.stream().map(Role::name).toArray()).append(")", new Object[0]).setMultimap(H2RoleDAO::replacementCol, H2RoleDAO::roleCol);
    }

    @Nonnull
    private static DirectlyResolvableRole roleCol(ResultSet rs) throws SQLException {
        return (DirectlyResolvableRole)Role.valueOf((String)rs.getString("role"));
    }

    @Nonnull
    private static Role replacementCol(ResultSet rs) throws SQLException {
        return Role.valueOf((String)rs.getString("replacement"));
    }

    public ImmutableSet<DirectlyResolvableRole> filterRolesForProfiles(Set<? extends DirectlyResolvableRole> rolesToResolve, Set<ProfileRole> profileRoles) {
        return this._daoSupport.prep("SELECT role FROM role_replacement WHERE role = ANY (").appendParam((Object)rolesToResolve.stream().map(Role::name).toArray()).append(") AND replacement = ANY (", new Object[0]).appendParam((Object)profileRoles.stream().map(Role::name).toArray()).append(")", new Object[0]).set(H2RoleDAO::roleCol);
    }
}

