/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.kafka.impl;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.permission.kafka.KafkaConfigurationProvider;
import de.justsoftware.permission.kafka.impl.KafkaProducerConfiguration;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
@ConditionalOnProperty(value={"kafka.enabled"})
public class KafkaProducerConfiguration {
    @VisibleForTesting
    public static final String KAFKA_STRING_PRODUCER = "KAFKA_STRING_PRODUCER";

    @Bean(name={"KAFKA_STRING_PRODUCER"}, destroyMethod="close")
    @CheckForNull
    public KafkaProducer<String, String> createStringProducer(KafkaConfigurationProvider kafkaConfigurationProvider) {
        Properties props = kafkaConfigurationProvider.producerConfig();
        return props != null ? new ClosingKafkaProducer(props) : null;
    }
}

