/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.offsets.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.permission.business.offsets.ConsumerOffsetService;
import de.justsoftware.permission.persistence.AfterCommitCallback;
import de.justsoftware.permission.persistence.ConsumerOffsetDAO;
import de.justsoftware.toolbox.stream.EntryCollectors;
import de.justsoftware.toolbox.stream.EntryStream;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ConsumerOffsetServiceImpl
implements ConsumerOffsetService {
    private final ReentrantLock _consumerOffsetLock = new ReentrantLock();
    private final ConcurrentMap<String, Condition> _consumerOffsetsLoaded = new ConcurrentHashMap();
    private final ConsumerOffsetDAO _consumerOffsetDAO;
    private final Clock _clock;

    @Autowired
    public ConsumerOffsetServiceImpl(ConsumerOffsetDAO consumerOffsetDAO, Clock clock) {
        this._consumerOffsetDAO = consumerOffsetDAO;
        this._clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConsumed(Map<String, Long> offsets, long timeoutMs) {
        if (offsets.isEmpty()) {
            return true;
        }
        Instant deadline = this._clock.instant().plusMillis(timeoutMs);
        this._consumerOffsetLock.lock();
        try {
            ImmutableMap waiting = ImmutableMap.copyOf(offsets);
            while (true) {
                ImmutableMap storedOffsets = this._consumerOffsetDAO.getOffsets((Set)waiting.keySet());
                if ((waiting = (ImmutableMap)EntryStream.from((Map)waiting).filter((tp, offset) -> {
                    Long storedOffset = (Long)storedOffsets.get(tp);
                    return storedOffset == null || storedOffset < offset;
                }).collect(EntryCollectors.toImmutableMap())).isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                String anyTopicPartition = (String)waiting.keySet().iterator().next();
                long remainingMillis = this._clock.instant().until(deadline, ChronoUnit.MILLIS);
                if (remainingMillis <= 0L || !this.getWaitCondition(anyTopicPartition).await(remainingMillis, TimeUnit.MILLISECONDS)) {
                    boolean bl = false;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this._consumerOffsetLock.unlock();
        }
    }

    public AfterCommitCallback storeOffsets(Map<String, Long> consumedOffsets) {
        this._consumerOffsetDAO.storeOffsets(consumedOffsets);
        return () -> this.notifyOffsetsUpdated(consumedOffsets.keySet());
    }

    private void notifyOffsetsUpdated(Set<String> updatedTopicPartitions) {
        try {
            this._consumerOffsetLock.lock();
            updatedTopicPartitions.forEach(tp -> this.getWaitCondition(tp).signalAll());
        }
        finally {
            this._consumerOffsetLock.unlock();
        }
    }

    @Nonnull
    private Condition getWaitCondition(String topicPartition) {
        return this._consumerOffsetsLoaded.computeIfAbsent(topicPartition, tp -> this._consumerOffsetLock.newCondition());
    }
}

