/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.item.model;

import de.justsoftware.permission.business.item.model.ItemType;
import de.justsoftware.toolbox.model.AbstractImmutableEqualsObject;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@Schema(type="String")
@ParametersAreNonnullByDefault
public final class ItemId
extends AbstractImmutableEqualsObject {
    public static final char SEPARATOR = ',';
    private final String _id;
    private final ItemType _type;
    private final String _plainId;

    private ItemId(String id, ItemType type, String plainId) {
        super(new Object[]{id});
        this._id = id;
        this._type = type;
        this._plainId = plainId;
    }

    @Nonnull
    public static ItemId valueOf(String id) {
        String trimmedId = StringUtils.trimToNull((String)id);
        if (StringUtils.isBlank((CharSequence)trimmedId)) {
            throw new IllegalArgumentException("empty string supplied for nonnull method");
        }
        int comma = trimmedId.indexOf(44);
        switch (comma) {
            case 0: {
                throw new IllegalArgumentException("item id without type");
            }
            case -1: {
                throw new IllegalArgumentException("item id without comma");
            }
        }
        ItemType type = ItemType.get((String)trimmedId.substring(0, comma));
        String plainId = trimmedId.substring(comma + 1);
        if (StringUtils.isBlank((CharSequence)plainId)) {
            throw new IllegalArgumentException("item id with empty id part");
        }
        return new ItemId(trimmedId, type, plainId);
    }

    @Nonnull
    public ItemType getType() {
        return this._type;
    }

    @Nonnull
    public String getPlainId() {
        return this._plainId;
    }

    @Nonnull
    public String asString() {
        return this._id;
    }

    public String toString() {
        return this._id;
    }
}

