/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.item.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.permission.business.item.model.Item;
import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.business.item.model.ItemType;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Item {
    private final ItemId _id;
    private final Optional<ItemId> _parentId;
    private final ImmutableSet<String> _params;

    public Item(ItemId itemId, @Nullable ItemId parentId, Set<String> params) {
        this._id = itemId;
        this._parentId = Optional.ofNullable(parentId);
        this._params = ImmutableSet.copyOf(params);
    }

    public Item(ItemId itemId, @Nullable ItemId parentId) {
        this(itemId, parentId, (Set)ImmutableSet.of());
    }

    @Nonnull
    public ItemId getId() {
        return this._id;
    }

    @Nonnull
    public ItemType getType() {
        return this._id.getType();
    }

    @Nonnull
    public Optional<ItemId> getParentId() {
        return this._parentId;
    }

    @Nonnull
    public ImmutableSet<String> getParams() {
        return this._params;
    }

    @Nonnull
    public static ItemBuilder builder(ItemId itemId) {
        return new ItemBuilder(itemId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("parentId", (Object)this._parentId).add("params", (Object)this._params).toString();
    }
}

