/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.internal;

import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.kafka.drive.KafkaDriveProducer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/news/internal/InternalRepublishService;", "", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "kafkaDriveProducer", "Lde/justsoftware/news/kafka/drive/KafkaDriveProducer;", "(Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/kafka/drive/KafkaDriveProducer;)V", "log", "Lorg/slf4j/Logger;", "getTenantId", "Lde/justsoftware/news/id/TenantId;", "channels", "", "Lde/justsoftware/news/domain/channel/Channel;", "post", "Lde/justsoftware/news/domain/post/Post;", "republishAll", "", "news-service"})
@SourceDebugExtension(value={"SMAP\nInternalRepublishService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalRepublishService.kt\nde/justsoftware/news/internal/InternalRepublishService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1726#2,3:63\n1#3:66\n*S KotlinDebug\n*F\n+ 1 InternalRepublishService.kt\nde/justsoftware/news/internal/InternalRepublishService\n*L\n58#1:63,3\n*E\n"})
public class InternalRepublishService {
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final KafkaDriveProducer kafkaDriveProducer;
    @NotNull
    private final Logger log;

    public InternalRepublishService(@NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull ChannelRepo channelRepo, @NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PostRepo postRepo, @NotNull KafkaDriveProducer kafkaDriveProducer) {
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)kafkaDriveProducer, (String)"kafkaDriveProducer");
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.channelRepo = channelRepo;
        this.channelPermissionRepo = channelPermissionRepo;
        this.postRepo = postRepo;
        this.kafkaDriveProducer = kafkaDriveProducer;
        Logger logger = LoggerFactory.getLogger(InternalRepublishService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void republishAll() {
        this.log.debug("Republishing channel items");
        Set channels = this.channelRepo.getAllByDeletedFalse();
        this.permissionKafkaProducer.republishChannels((Iterable)channels);
        this.permissionKafkaProducer.republishChannelRoles((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.log.debug("Republishing post items");
        AutoCloseable autoCloseable = this.postRepo.getAllByDeletedFalse();
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            this.permissionKafkaProducer.republishPosts((Function0)new /* Unavailable Anonymous Inner Class!! */);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.log.debug("Republishing complete");
    }

    private TenantId getTenantId(Set<Channel> channels, Post post) {
        TenantId tenantId;
        boolean onlyOneTenant;
        TenantId firstTenantId;
        block6: {
            firstTenantId = ((Channel)CollectionsKt.first((Iterable)channels)).getTenantId();
            Iterable $this$all$iv = channels;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Channel it = (Channel)element$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getTenantId(), (Object)firstTenantId)) continue;
                    v0 = false;
                    break block6;
                }
                v0 = onlyOneTenant = true;
            }
        }
        if (onlyOneTenant) {
            tenantId = firstTenantId;
        } else {
            Object v2;
            block7: {
                Iterable iterable = channels;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Channel it = (Channel)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)post.getChannelId())) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            Channel channel = v2;
            Object object = channel != null ? channel.getTenantId() : null;
            tenantId = object;
            Intrinsics.checkNotNull((Object)object);
        }
        return tenantId;
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(InternalRepublishService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ChannelPermissionRepo access$getChannelPermissionRepo$p(InternalRepublishService $this) {
        return $this.channelPermissionRepo;
    }

    public static final /* synthetic */ KafkaDriveProducer access$getKafkaDriveProducer$p(InternalRepublishService $this) {
        return $this.kafkaDriveProducer;
    }

    public static final /* synthetic */ TenantId access$getTenantId(InternalRepublishService $this, Set channels, Post post) {
        return $this.getTenantId(channels, post);
    }
}

