/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.graphql;

import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.types.errors.ErrorDetail;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import de.justsoftware.news.auth.exceptions.NotAuthorizedException;
import de.justsoftware.news.auth.exceptions.NotFoundException;
import de.justsoftware.news.domain.error.NewsException;
import de.justsoftware.news.domain.post.error.PostAlreadyUpdatedException;
import de.justsoftware.news.graphql.ApiError;
import de.justsoftware.news.graphql.ErrorHandler;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/news/graphql/ErrorHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "()V", "defaultHandler", "Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "getApiError", "Lde/justsoftware/news/graphql/ApiError;", "exception", "Lde/justsoftware/news/domain/error/NewsException;", "onException", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "Companion", "news-service"})
public class ErrorHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultDataFetcherExceptionHandler defaultHandler = new DefaultDataFetcherExceptionHandler();
    @NotNull
    private static final Logger log;

    private ApiError getApiError(NewsException exception) {
        return exception instanceof PostAlreadyUpdatedException ? ApiError.POST_ALREADY_UPDATED_ERROR : ApiError.GENERAL_ERROR;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public DataFetcherExceptionHandlerResult onException(@Nullable DataFetcherExceptionHandlerParameters handlerParameters) {
        DataFetcherExceptionHandlerParameters dataFetcherExceptionHandlerParameters = handlerParameters;
        Intrinsics.checkNotNull((Object)dataFetcherExceptionHandlerParameters);
        Throwable exception = dataFetcherExceptionHandlerParameters.getException();
        log.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
        Throwable throwable = exception;
        if (throwable instanceof NewsException) {
            DataFetcherExceptionHandlerResult.Builder builder = DataFetcherExceptionHandlerResult.newResult();
            TypedGraphQLError.Builder builder2 = TypedGraphQLError.newConflictBuilder().message(exception.getMessage()).path(handlerParameters.getPath());
            Intrinsics.checkNotNull((Object)exception);
            DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = builder.error((GraphQLError)builder2.extensions(MapsKt.mapOf((Pair)new Pair((Object)"apiError", (Object)this.getApiError((NewsException)exception)))).build()).build();
            Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"build(...)");
            return dataFetcherExceptionHandlerResult;
        }
        if (throwable instanceof IllegalArgumentException) {
            DataFetcherExceptionHandlerResult.Builder builder = DataFetcherExceptionHandlerResult.newResult();
            TypedGraphQLError.Builder builder3 = TypedGraphQLError.newBadRequestBuilder().message("Bad Request").path(handlerParameters.getPath()).errorDetail((ErrorDetail)ErrorDetail.Common.INVALID_ARGUMENT);
            Intrinsics.checkNotNull((Object)exception);
            DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = builder.error((GraphQLError)builder3.origin(exception.getClass().getSimpleName() + ": " + exception.getMessage()).build()).build();
            Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"build(...)");
            return dataFetcherExceptionHandlerResult;
        }
        if (throwable instanceof NotAuthorizedException) {
            DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)TypedGraphQLError.newPermissionDeniedBuilder().message("Not authorized").origin(exception.getMessage()).path(handlerParameters.getPath()).build()).build();
            Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"build(...)");
            return dataFetcherExceptionHandlerResult;
        }
        if (throwable instanceof NotFoundException) {
            DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)TypedGraphQLError.newNotFoundBuilder().message("Not found").origin(exception.getMessage()).path(handlerParameters.getPath()).build()).build();
            Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"build(...)");
            return dataFetcherExceptionHandlerResult;
        }
        if (throwable instanceof RuntimeException) {
            DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)TypedGraphQLError.newInternalErrorBuilder().message("Internal Server Error").origin(exception.getMessage()).path(handlerParameters.getPath()).build()).build();
            Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"build(...)");
            return dataFetcherExceptionHandlerResult;
        }
        Object t = this.defaultHandler.handleException(handlerParameters).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (DataFetcherExceptionHandlerResult)t;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

