/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.comment.AllowedActionsDataLoader;
import de.justsoftware.news.domain.comment.CommentWithSortOrder;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentAction;
import de.justsoftware.news.domain.comment.PostCommentDataFetcherKt;
import de.justsoftware.news.domain.comment.PostCommentService;
import de.justsoftware.news.domain.comment.Reference;
import de.justsoftware.news.domain.comment.Responses;
import de.justsoftware.news.domain.reaction.ReactionDataLoader;
import de.justsoftware.news.domain.user.ProfileDataLoader;
import de.justsoftware.news.graphql.generated.types.AddCommentInput;
import de.justsoftware.news.graphql.generated.types.Comment;
import de.justsoftware.news.graphql.generated.types.Likes;
import de.justsoftware.news.graphql.generated.types.PostCommentReference;
import de.justsoftware.news.graphql.generated.types.Profile;
import de.justsoftware.news.graphql.generated.types.Reaction;
import de.justsoftware.news.graphql.generated.types.UpdateCommentInput;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.CommentableId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Sort;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\t\u001a\u00020\nH\u0017J$\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001d0\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010 \u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020!2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/news/domain/comment/PostCommentDataFetcher;", "", "commentService", "Lde/justsoftware/news/domain/comment/PostCommentService;", "(Lde/justsoftware/news/domain/comment/PostCommentService;)V", "addComment", "Lde/justsoftware/news/graphql/generated/types/Comment;", "input", "Lde/justsoftware/news/graphql/generated/types/AddCommentInput;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "allowedActions", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/news/domain/comment/PostCommentAction;", "author", "Lde/justsoftware/news/graphql/generated/types/Profile;", "comment", "id", "Lde/justsoftware/news/id/CommentId;", "deleteComment", "likes", "Lgraphql/execution/DataFetcherResult;", "Lde/justsoftware/news/graphql/generated/types/Likes;", "reactions", "Lde/justsoftware/news/graphql/generated/types/Reaction;", "reference", "Lde/justsoftware/news/graphql/generated/types/PostCommentReference;", "responses", "", "sort", "Lde/justsoftware/news/util/Sort;", "updateComment", "Lde/justsoftware/news/graphql/generated/types/UpdateCommentInput;", "news-service"})
public class PostCommentDataFetcher {
    @NotNull
    private final PostCommentService commentService;

    public PostCommentDataFetcher(@NotNull PostCommentService commentService) {
        Intrinsics.checkNotNullParameter((Object)commentService, (String)"commentService");
        this.commentService = commentService;
    }

    @DgsMutation(field="addComment")
    @NotNull
    public Comment addComment(@InputArgument @NotNull AddCommentInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return PostCommentDataFetcherKt.toGql((PostComment)this.commentService.createComment(input.getPostId(), input.getText(), input.getJsonContent(), (ItemId)input.getParentId(), (ItemId)input.getReferenceId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="deleteComment")
    @NotNull
    public CommentId deleteComment(@InputArgument @NotNull CommentId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.commentService.deleteComment(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsMutation(field="updateComment")
    @NotNull
    public Comment updateComment(@InputArgument @NotNull UpdateCommentInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return PostCommentDataFetcherKt.toGql((PostComment)this.commentService.update(input.getCommentId(), input.getText(), input.getJsonContent(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsQuery(field="comment")
    @Nullable
    public Comment comment(@InputArgument @NotNull CommentId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostComment postComment = this.commentService.findById(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return postComment != null ? PostCommentDataFetcherKt.toGql((PostComment)postComment) : null;
    }

    @DgsData(parentType="Comment", field="author")
    @NotNull
    public CompletableFuture<Profile> author(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId authorId = ((Comment)dfe.getSource()).getAuthorId();
        CompletableFuture completableFuture = dataLoader.load((Object)authorId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="reference")
    @NotNull
    public CompletableFuture<PostCommentReference> reference(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(Reference.class);
        String referenceId = ((Comment)dfe.getSource()).getReferenceId();
        CompletableFuture completableFuture = dataLoader.load((Object)CommentableId.Companion.fromString(referenceId));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="reactions")
    @NotNull
    public CompletableFuture<Reaction> reactions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ReactionDataLoader.class);
        CommentId commentId = ((Comment)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)commentId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="allowedActions")
    @NotNull
    public CompletableFuture<Set<PostCommentAction>> allowedActions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Comment comment = (Comment)dfe.getSource();
        DataLoader dataLoader = dfe.getDataLoader(AllowedActionsDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)comment);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="responses")
    @NotNull
    public CompletableFuture<List<Comment>> responses(@NotNull Sort sort, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Comment comment = (Comment)dfe.getSource();
        DataLoader dataLoader = dfe.getDataLoader(Responses.class);
        Intrinsics.checkNotNull((Object)comment);
        CompletableFuture completableFuture = dataLoader.load((Object)new CommentWithSortOrder(comment, sort));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Comment", field="likes")
    @NotNull
    public DataFetcherResult<Likes> likes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataFetcherResult dataFetcherResult = DataFetcherResult.newResult().data((Object)new Likes(null, null, null, 7, null)).localContext((Object)((Comment)dfe.getSource()).getId()).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherResult, (String)"build(...)");
        return dataFetcherResult;
    }
}

