/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.permission;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.news.auth.exceptions.NotAuthorizedException;
import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.connector.permission.PermissionConnectorKt;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0017\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J:\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u0016\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u0018\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u001a\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\r2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\r0\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\"0\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010&\u001a\u00020\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0012J*\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\"0\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0012J\u0018\u0010*\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lde/justsoftware/news/connector/permission/PermissionConnector;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;)V", "checkAppWriterNews", "", "tenantId", "Lde/justsoftware/news/id/TenantId;", "userId", "Lde/justsoftware/news/id/UserId;", "checkItemResults", "itemIds", "", "Lde/justsoftware/news/id/ItemId;", "permissionResults", "", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "roleToCheck", "Lde/justsoftware/news/connector/permission/PermissionConnector$Companion$RoleToCheck;", "checkManage", "itemId", "checkManageAll", "checkRead", "checkReadAll", "checkWrite", "checkWriteAll", "filterUsersRoles", "", "Lde/justsoftware/permission/client/model/Role;", "itemRoles", "getRolesWhoRead", "", "isSuperAdmin", "", "mayManage", "item", "items", "mayManageAll", "mayManageResults", "mayRead", "mayReadResults", "mayWriteAppNews", "mayWriteResults", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nPermissionConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionConnector.kt\nde/justsoftware/news/connector/permission/PermissionConnector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,167:1\n453#2:168\n403#2:169\n453#2:174\n403#2:175\n468#2:206\n414#2:207\n453#2:212\n403#2:213\n468#2:222\n414#2:223\n453#2:228\n403#2:229\n468#2:238\n414#2:239\n453#2:244\n403#2:245\n1238#3,4:170\n1238#3,4:176\n1726#3,3:183\n1726#3,3:186\n1549#3:189\n1620#3,3:190\n1179#3,2:193\n1253#3,2:195\n1549#3:197\n1620#3,3:198\n1256#3:201\n1549#3:202\n1620#3,3:203\n1238#3,4:208\n1238#3,4:214\n1549#3:218\n1620#3,3:219\n1238#3,4:224\n1238#3,4:230\n1549#3:234\n1620#3,3:235\n1238#3,4:240\n1238#3,4:246\n1855#3,2:250\n167#4,3:180\n*S KotlinDebug\n*F\n+ 1 PermissionConnector.kt\nde/justsoftware/news/connector/permission/PermissionConnector\n*L\n43#1:168\n43#1:169\n48#1:174\n48#1:175\n116#1:206\n116#1:207\n117#1:212\n117#1:213\n125#1:222\n125#1:223\n126#1:228\n126#1:229\n134#1:238\n134#1:239\n135#1:244\n135#1:245\n43#1:170,4\n48#1:176,4\n57#1:183,3\n66#1:186,3\n104#1:189\n104#1:190,3\n107#1:193,2\n107#1:195,2\n107#1:197\n107#1:198,3\n107#1:201\n113#1:202\n113#1:203,3\n116#1:208,4\n117#1:214,4\n122#1:218\n122#1:219,3\n125#1:224,4\n126#1:230,4\n131#1:234\n131#1:235,3\n134#1:240,4\n135#1:246,4\n147#1:250,2\n51#1:180,3\n*E\n"})
public class PermissionConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private static final Logger log;

    public PermissionConnector(@NotNull PermissionRequestConnector permissionRequestConnector) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        this.permissionRequestConnector = permissionRequestConnector;
    }

    @NotNull
    public Set<Role> filterUsersRoles(@NotNull Collection<Role> itemRoles, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemRoles, (String)"itemRoles");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        ImmutableSet immutableSet = this.permissionRequestConnector.filterRoles((Iterable)CollectionsKt.toSet((Iterable)itemRoles), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"filterRoles(...)");
        return (Set)immutableSet;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Boolean> mayRead(@NotNull Collection<? extends ItemId> items, @NotNull UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map $this$mapValues$iv = this.mayReadResults(items, userId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }

    public boolean mayManage(@NotNull ItemId item, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (Boolean)CollectionsKt.first((Iterable)this.mayManage((Collection)CollectionsKt.listOf((Object)item), userId).values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Boolean> mayManage(@NotNull Collection<? extends ItemId> items, @NotNull UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map $this$mapValues$iv = this.mayManageResults(items, userId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }

    public boolean mayManageAll(@NotNull Collection<? extends ItemId> items, @NotNull UserId userId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Map $this$all$iv = this.mayManageResults(items, userId);
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (it.getValue() == AuthorizationResult.OK) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean mayWriteAppNews(@NotNull TenantId tenantId, @NotNull UserId userId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Collection collection = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)Role.write((String)("APP,news_" + tenantId.getValue()))), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString()))).values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AuthorizationResult it = (AuthorizationResult)element$iv;
                    boolean bl2 = false;
                    if (it == AuthorizationResult.OK) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean isSuperAdmin(@NotNull UserId userId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Collection collection = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)Role.SUPERADMIN), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString()))).values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AuthorizationResult it = (AuthorizationResult)element$iv;
                    boolean bl2 = false;
                    if (it == AuthorizationResult.OK) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public void checkRead(@NotNull ItemId itemId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.checkReadAll((Collection)SetsKt.setOf((Object)itemId), userId);
    }

    public void checkReadAll(@NotNull Collection<? extends ItemId> itemIds, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map permissionResults = this.mayReadResults(itemIds, userId);
        this.checkItemResults(itemIds, permissionResults, userId, Companion.RoleToCheck.READ);
    }

    public void checkWrite(@NotNull ItemId itemId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.checkWriteAll((Collection)SetsKt.setOf((Object)itemId), userId);
    }

    public void checkWriteAll(@NotNull Collection<? extends ItemId> itemIds, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map permissionResults = this.mayWriteResults(itemIds, userId);
        this.checkItemResults(itemIds, permissionResults, userId, Companion.RoleToCheck.WRITE);
    }

    public void checkManage(@NotNull ItemId itemId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.checkManageAll((Collection)SetsKt.setOf((Object)itemId), userId);
    }

    public void checkManageAll(@NotNull Collection<? extends ItemId> itemIds, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map permissionResults = this.mayManageResults(itemIds, userId);
        this.checkItemResults(itemIds, permissionResults, userId, Companion.RoleToCheck.MANAGE);
    }

    public void checkAppWriterNews(@NotNull TenantId tenantId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (!this.mayWriteAppNews(tenantId, userId)) {
            throw new NotAuthorizedException("User '" + userId.toTypedString() + "' is not authorized to WRITE APP NEWS!");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Collection<String>> getRolesWhoRead(@NotNull Collection<? extends ItemId> itemIds) {
        void $this$associateTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable iterable = CollectionsKt.toSet((Iterable)itemIds);
        PermissionRequestConnector permissionRequestConnector = this.permissionRequestConnector;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (ItemId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        Set set = permissionRequestConnector.visibility((Iterable)((List)destination$iv$iv)).asMap().entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            object = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            ItemId itemId = ItemId.Companion.fromString((String)k);
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            Iterable iterable2 = (Iterable)v;
            ItemId itemId2 = itemId;
            boolean $i$f$map2 = false;
            void var16_20 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void role;
                Role role2 = (Role)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string = role.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                collection.add(string);
            }
            Pair pair = TuplesKt.to((Object)itemId2, (Object)((List)destination$iv$iv2));
            object.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayReadResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.read((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayWriteResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.write((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayManageResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.manage((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }

    private void checkItemResults(Collection<? extends ItemId> itemIds, Map<ItemId, ? extends AuthorizationResult> permissionResults, UserId userId, Companion.RoleToCheck roleToCheck) {
        List notAllowed = new ArrayList();
        List notFound = new ArrayList();
        Iterable $this$forEach$iv = itemIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemId it = (ItemId)element$iv;
            boolean bl = false;
            AuthorizationResult authorizationResult = permissionResults.get(it);
            switch (authorizationResult == null ? -1 : WhenMappings.$EnumSwitchMapping$0[authorizationResult.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    notFound.add(it);
                    break;
                }
                case 3: {
                    notAllowed.add(it);
                    break;
                }
                default: {
                    notAllowed.add(it);
                }
            }
        }
        if (!((Collection)notAllowed).isEmpty()) {
            log.warn("User: '" + userId.toTypedString() + "' is not authorized to " + roleToCheck + " items: '" + notAllowed + "'.");
        }
        if (!((Collection)notFound).isEmpty()) {
            log.error("Items not known to permission: '" + notFound + "'.");
        }
        if (!((Collection)notAllowed).isEmpty() || !((Collection)notFound).isEmpty()) {
            throw new NotAuthorizedException("User: '" + userId.toTypedString() + "' is not authorized.");
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(PermissionConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

