/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import de.justsoftware.justimport.persistence.model.DbUserGroup;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DbUserGroupBuilder {
    private UUID _id = UUID.randomUUID();
    private UUID _tenantId = UUID.randomUUID();
    private String _name;
    private boolean _isAllTenantUsersGroup = false;
    private Instant _importedAt;
    private ImportMethod _importMethod;

    @Nonnull
    public DbUserGroupBuilder from(@Nonnull DbUserGroup group) {
        this._id = group.getId();
        this._tenantId = group.getTenantId();
        this._name = group.getName();
        this._isAllTenantUsersGroup = group.isAllTenantUsersGroup();
        this._importedAt = group.getImportedAt();
        this._importMethod = group.getImportMethod();
        return this;
    }

    @Nonnull
    public DbUserGroupBuilder setId(UUID id) {
        this._id = id;
        return this;
    }

    @Nonnull
    public DbUserGroupBuilder setTenantId(UUID tenantId) {
        this._tenantId = tenantId;
        return this;
    }

    @Nonnull
    public DbUserGroupBuilder setName(String name) {
        this._name = name;
        return this;
    }

    @Nonnull
    public DbUserGroupBuilder setIsAllTenantUsersGroup(boolean isAllUsersGroup) {
        this._isAllTenantUsersGroup = isAllUsersGroup;
        return this;
    }

    @Nonnull
    public DbUserGroupBuilder setImportedAt(@Nullable Instant importedAt) {
        this._importedAt = importedAt;
        return this;
    }

    @Nonnull
    public DbUserGroupBuilder setImportMethod(@Nullable ImportMethod importMethod) {
        this._importMethod = importMethod;
        return this;
    }

    @Nonnull
    public DbUserGroup build() {
        return new DbUserGroup(this._id, this._name, this._tenantId, this._isAllTenantUsersGroup, this._importedAt, this._importMethod);
    }
}

