/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import de.justsoftware.justimport.domain.model.common.AbstractId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.persistence.model.DbProfile;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DbProfileBuilder {
    private Long _id;
    private UUID _uuid = UUID.randomUUID();
    private UUID _tenantId;
    private String _email;
    private String _fullName;
    private String _firstName;
    private String _lastName;
    private String _profileUrl;
    private String _imageUrl = "/storageserver/images/original/user/default.png?v=10";
    private boolean _active = true;
    private boolean _blocked = false;
    private boolean _deleted = false;
    private Instant _importedAt;
    private ImportMethod _importMethod;

    @Nonnull
    public DbProfileBuilder from(@Nonnull DbProfile profile) {
        this._id = profile.getId();
        this._uuid = profile.getUuid();
        this._tenantId = profile.getTenantId();
        this._email = profile.getEmail();
        this._fullName = profile.getFullName();
        this._firstName = profile.getFirstName();
        this._lastName = profile.getLastName();
        this._profileUrl = profile.getProfileUrl();
        this._imageUrl = profile.getImageUrl();
        this._active = profile.isActive();
        this._blocked = profile.isBlocked();
        this._deleted = profile.isDeleted();
        this._importedAt = profile.getImportedAt();
        this._importMethod = profile.getImportMethod();
        return this;
    }

    @Nonnull
    public DbProfileBuilder setId(@Nullable Long id) {
        this._id = id;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setId(@Nullable ProfileId id) {
        this._id = ProfileId.longId((AbstractId)id);
        return this;
    }

    @Nonnull
    public DbProfileBuilder setUuid(UUID uuid) {
        this._uuid = uuid;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setTenantId(@Nullable UUID tenantId) {
        this._tenantId = tenantId;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setEmail(String email) {
        this._email = email;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setFullName(@Nullable String fullName) {
        this._fullName = fullName;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setFirstName(String firstName) {
        this._firstName = firstName;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setLastName(String lastName) {
        this._lastName = lastName;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setProfileUrl(@Nullable String profileUrl) {
        this._profileUrl = profileUrl;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setImageUrl(@Nullable String imageUrl) {
        this._imageUrl = imageUrl;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setActive(boolean active) {
        this._active = active;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setBlocked(boolean blocked) {
        this._blocked = blocked;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setDeleted(boolean deleted) {
        this._deleted = deleted;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setImportedAt(@Nullable Instant importedAt) {
        this._importedAt = importedAt;
        return this;
    }

    @Nonnull
    public DbProfileBuilder setImportMethod(@Nullable ImportMethod importMethod) {
        this._importMethod = importMethod;
        return this;
    }

    @Nonnull
    public DbProfile build() {
        return new DbProfile(this._id, this._uuid, this._tenantId, this._email, (String)(this._fullName == null ? this._firstName + " " + this._lastName : this._fullName), this._firstName, this._lastName, this._profileUrl, this._imageUrl, this._active, this._blocked, this._deleted, this._importedAt, this._importMethod);
    }
}

