/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.config;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.ldap.LdapProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.pool2.factory.PoolConfig;
import org.springframework.ldap.pool2.factory.PooledContextSource;
import org.springframework.ldap.pool2.validation.DefaultDirContextValidator;
import org.springframework.ldap.pool2.validation.DirContextValidator;

@ParametersAreNonnullByDefault
@Configuration
@ConditionalOnProperty(name={"just.import.pooling.enabled"}, havingValue="true")
@Profile(value={"!test"})
public class ContextSourceConfig {
    @Primary
    @Bean
    @Nonnull
    public ContextSource createContextSource(LdapProperties properties, Environment environment, @Value(value="${just.import.pooling.maxConnections:5}") int maxConnections, @Value(value="${just.import.pooling.maxWaitMillis:60000}") int maxWaitMillis, @Value(value="${just.import.pooling.timeBetweenEvictionRunsMillis:30000}") int timeBetweenEvictionRunsMillis, @Value(value="${just.import.pooling.testsPerEvictionRun:10}") int testsPerEvictionRun) {
        LdapContextSource ldapCtxSource = new LdapContextSource();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from((Object)properties.getUsername()).to(arg_0 -> ((LdapContextSource)ldapCtxSource).setUserDn(arg_0));
        propertyMapper.from((Object)properties.getPassword()).to(arg_0 -> ((LdapContextSource)ldapCtxSource).setPassword(arg_0));
        propertyMapper.from((Object)properties.getAnonymousReadOnly()).to(arg_0 -> ((LdapContextSource)ldapCtxSource).setAnonymousReadOnly(arg_0));
        propertyMapper.from((Object)properties.getBase()).to(arg_0 -> ((LdapContextSource)ldapCtxSource).setBase(arg_0));
        propertyMapper.from((Object)properties.determineUrls(environment)).to(arg_0 -> ((LdapContextSource)ldapCtxSource).setUrls(arg_0));
        propertyMapper.from((Object)properties.getBaseEnvironment()).to(baseEnvironment -> ldapCtxSource.setBaseEnvironmentProperties(Collections.unmodifiableMap(baseEnvironment)));
        ldapCtxSource.afterPropertiesSet();
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setMaxIdlePerKey(maxConnections / 2);
        poolConfig.setMaxTotal(maxConnections);
        poolConfig.setMaxWaitMillis((long)maxWaitMillis);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setBlockWhenExhausted(true);
        poolConfig.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis);
        poolConfig.setNumTestsPerEvictionRun(testsPerEvictionRun);
        PooledContextSource pooledCtxSource = new PooledContextSource(poolConfig);
        pooledCtxSource.setDirContextValidator((DirContextValidator)new DefaultDirContextValidator());
        pooledCtxSource.setContextSource((ContextSource)ldapCtxSource);
        return pooledCtxSource;
    }
}

