/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.usergroup;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.types.GroupResource;
import com.unboundid.scim2.common.types.Member;
import de.justsoftware.justimport.persistence.UserGroupMemberRepository;
import de.justsoftware.justimport.persistence.UserGroupRepository;
import de.justsoftware.justimport.persistence.model.DbUserGroup;
import de.justsoftware.justimport.persistence.model.DbUserGroupMember;
import de.justsoftware.justimport.persistence.model.DbUserGroupMemberId;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import jakarta.annotation.Nonnull;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ScimGroupsService {
    private static final UUID HARD_CODED_TENANT_ID = UUID.fromString("9d9694df-5abe-434f-8c41-2e5ae509ef23");
    private final UserGroupRepository _groupRepo;
    private final UserGroupMemberRepository _groupMemberRepo;
    private final ObjectMapper _mapper;

    @Autowired
    public ScimGroupsService(UserGroupRepository groupRepo, UserGroupMemberRepository groupMemberRepo, ObjectMapper mapper) {
        this._groupRepo = groupRepo;
        this._groupMemberRepo = groupMemberRepo;
        this._mapper = mapper;
    }

    @Nonnull
    public List<GroupResource> find(SearchRequest searchRequest) throws ScimException {
        String filterValue = this.getFilterValue(searchRequest);
        if (filterValue == null) {
            return List.of();
        }
        Optional dbGroup = this._groupRepo.findByNameIgnoreCase(filterValue);
        if (dbGroup.isEmpty()) {
            return List.of();
        }
        List members = this._groupMemberRepo.findAllById_UserGroupId(((DbUserGroup)dbGroup.get()).getId());
        return List.of(this.toGroupResource((DbUserGroup)dbGroup.get(), members));
    }

    @Nonnull
    public GroupResource byId(UUID id) throws ResourceNotFoundException {
        Optional group = this._groupRepo.findById((Object)id);
        if (group.isEmpty()) {
            throw ScimGroupsService.groupNotFound((UUID)id);
        }
        List members = this._groupMemberRepo.findAllById_UserGroupId(((DbUserGroup)group.get()).getId());
        return this.toGroupResource((DbUserGroup)group.get(), members);
    }

    @Nonnull
    @Transactional
    public GroupResource create(GroupResource group) throws ResourceConflictException {
        DbUserGroup dbGroup = this.toNewDbGroup(group);
        String name = group.getDisplayName();
        if (this._groupRepo.findByNameIgnoreCase(name).isPresent()) {
            throw new ResourceConflictException("Group with this name already exists");
        }
        List members = ScimGroupsService.getMembers((UUID)dbGroup.getId(), (GroupResource)group);
        DbUserGroup persistedGroup = (DbUserGroup)this._groupRepo.save((Object)dbGroup);
        List persistedMembers = members == null ? List.of() : this._groupMemberRepo.saveAll((Iterable)members);
        return this.toGroupResource(persistedGroup, persistedMembers);
    }

    @Transactional
    public void delete(UUID uuid) {
        this._groupMemberRepo.deleteAllById_UserGroupId(uuid);
        this._groupRepo.deleteById((Object)uuid);
    }

    @Nonnull
    @Transactional
    public GroupResource patch(UUID uuid, PatchRequest patch) throws ScimException, JsonProcessingException {
        List persistedMembers;
        Optional dbGroup = this._groupRepo.findById((Object)uuid);
        if (dbGroup.isEmpty()) {
            throw ScimGroupsService.groupNotFound((UUID)uuid);
        }
        List members = this._groupMemberRepo.findAllById_UserGroupId(uuid);
        GroupResource groupResource = this.toGroupResource((DbUserGroup)dbGroup.get(), members);
        GenericScimResource genericScimResource = groupResource.asGenericScimResource();
        patch.apply(genericScimResource);
        GroupResource patchedGroupResource = (GroupResource)this._mapper.readValue(genericScimResource.getObjectNode().toString(), GroupResource.class);
        DbUserGroup persistedGroup = (DbUserGroup)this._groupRepo.save((Object)this.toDbGroup(uuid, ((DbUserGroup)dbGroup.get()).getTenantId(), patchedGroupResource));
        List patchedMembers = ScimGroupsService.getMembers((UUID)uuid, (GroupResource)patchedGroupResource);
        if (patchedMembers != null) {
            this._groupMemberRepo.deleteAllById_UserGroupId(uuid);
            persistedMembers = this._groupMemberRepo.saveAll((Iterable)patchedMembers);
        } else {
            persistedMembers = List.of();
        }
        return this.toGroupResource(persistedGroup, persistedMembers);
    }

    @Nonnull
    @Transactional
    public GroupResource replace(UUID uuid, GroupResource group) throws ResourceNotFoundException {
        List persistedMembers;
        Optional existingGroup = this._groupRepo.findById((Object)uuid);
        if (existingGroup.isEmpty()) {
            throw ScimGroupsService.groupNotFound((UUID)uuid);
        }
        DbUserGroup dbGroup = this.toDbGroup(uuid, ((DbUserGroup)existingGroup.get()).getTenantId(), group);
        List members = ScimGroupsService.getMembers((UUID)uuid, (GroupResource)group);
        DbUserGroup persistedGroup = (DbUserGroup)this._groupRepo.save((Object)dbGroup);
        if (members != null) {
            this._groupMemberRepo.deleteAllById_UserGroupId(uuid);
            persistedMembers = this._groupMemberRepo.saveAll((Iterable)members);
        } else {
            persistedMembers = List.of();
        }
        return this.toGroupResource(persistedGroup, persistedMembers);
    }

    @Nonnull
    private DbUserGroup toNewDbGroup(GroupResource group) {
        return this.toDbGroup(UUID.randomUUID(), null, group);
    }

    @Nonnull
    private DbUserGroup toDbGroup(UUID id, @Nullable UUID tenantId, GroupResource group) {
        return new DbUserGroup(id, group.getDisplayName(), tenantId == null ? HARD_CODED_TENANT_ID : tenantId, false, Instant.now(), ImportMethod.SCIM);
    }

    @Nonnull
    private GroupResource toGroupResource(DbUserGroup group, @Nullable List<DbUserGroupMember> members) {
        GroupResource resource = new GroupResource();
        resource.setDisplayName(group.getName());
        resource.setId(group.getId().toString());
        if (members != null) {
            resource.setMembers(members.stream().map(member -> new Member().setValue(member.getId().getProfileId().toString())).toList());
        }
        return resource;
    }

    @CheckForNull
    private String getFilterValue(SearchRequest searchRequest) throws NotImplementedException, BadRequestException {
        String stringFilter = searchRequest.getFilter();
        if (stringFilter.isEmpty()) {
            return null;
        }
        String filterValue = null;
        Filter filter = Filter.fromString((String)stringFilter);
        if (filter != null && filter.getFilterType() == FilterType.EQUAL) {
            ValueNode comparisonValue = filter.getComparisonValue();
            if (comparisonValue.textValue().isEmpty()) {
                throw new NotImplementedException("Only equals filter supported");
            }
            filterValue = comparisonValue.textValue();
        }
        return filterValue == null ? null : URLDecoder.decode(filterValue, StandardCharsets.UTF_8);
    }

    @CheckForNull
    private static List<DbUserGroupMember> getMembers(UUID dbUserGroupId, GroupResource group) {
        List members = group.getMembers();
        return members == null ? null : members.stream().map(member -> new DbUserGroupMember(new DbUserGroupMemberId(UUID.fromString(member.getValue()), dbUserGroupId), Instant.now(), ImportMethod.SCIM)).toList();
    }

    @Nonnull
    private static ResourceNotFoundException groupNotFound(UUID id) {
        return new ResourceNotFoundException(String.format("Group with id %s not found", id));
    }
}

