/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.profile;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.types.Email;
import com.unboundid.scim2.common.types.Group;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.UserResource;
import de.justsoftware.justimport.persistence.ProfileRepository;
import de.justsoftware.justimport.persistence.UserGroupMemberRepository;
import de.justsoftware.justimport.persistence.model.DbProfile;
import de.justsoftware.justimport.persistence.model.DbUserGroupMember;
import de.justsoftware.justimport.persistence.model.DbUserGroupMemberId;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ScimUsersService {
    private final ProfileRepository _profileRepo;
    private final UserGroupMemberRepository _groupMemberRepo;
    private final ObjectMapper _mapper;

    @Autowired
    public ScimUsersService(ProfileRepository profileRepo, UserGroupMemberRepository groupMemberRepo, ObjectMapper mapper) {
        this._profileRepo = profileRepo;
        this._groupMemberRepo = groupMemberRepo;
        this._mapper = mapper;
    }

    @Nonnull
    public List<UserResource> find(SearchRequest searchRequest) throws NotImplementedException, BadRequestException {
        String filterValue = this.getFilterValue(searchRequest);
        if (filterValue == null) {
            return List.of();
        }
        Optional profile = this._profileRepo.findByEmailIgnoreCase(filterValue);
        if (profile.isEmpty()) {
            return List.of();
        }
        List memberships = this._groupMemberRepo.findAllById_ProfileId(((DbProfile)profile.get()).getUuid());
        return List.of(ScimUsersService.toUserResource((DbProfile)((DbProfile)profile.get()), (List)memberships));
    }

    @Nonnull
    @Transactional
    public UserResource create(UserResource user) throws ResourceConflictException, PreconditionFailedException {
        DbProfile dbProfile = DbProfile.toNewDbProfile((UserResource)user);
        String email = user.getUserName();
        if (this._profileRepo.findByEmailIgnoreCase(email).isPresent()) {
            throw new ResourceConflictException("User with this email already exists");
        }
        List memberships = ScimUsersService.getGroups((UUID)dbProfile.getUuid(), (UserResource)user);
        DbProfile persistedProfile = (DbProfile)this._profileRepo.save((Object)dbProfile);
        List persistedMemberships = memberships == null ? List.of() : this._groupMemberRepo.saveAll((Iterable)memberships);
        return ScimUsersService.toUserResource((DbProfile)persistedProfile, (List)persistedMemberships);
    }

    @Nonnull
    public UserResource byId(UUID uuid) throws ResourceNotFoundException {
        Optional dbProfile = this._profileRepo.findById((Object)uuid);
        if (dbProfile.isEmpty()) {
            throw ScimUsersService.userNotFound((UUID)uuid);
        }
        List memberships = this._groupMemberRepo.findAllById_ProfileId(uuid);
        return ScimUsersService.toUserResource((DbProfile)((DbProfile)dbProfile.get()), (List)memberships);
    }

    @Nonnull
    @Transactional
    public UserResource patch(UUID uuid, PatchRequest patch) throws ScimException, JsonProcessingException {
        List persistedMemberships;
        Optional dbProfile = this._profileRepo.findById((Object)uuid);
        if (dbProfile.isEmpty()) {
            throw ScimUsersService.userNotFound((UUID)uuid);
        }
        List memberships = this._groupMemberRepo.findAllById_ProfileId(uuid);
        UserResource user = ScimUsersService.toUserResource((DbProfile)((DbProfile)dbProfile.get()), (List)memberships);
        GenericScimResource genericScimResource = user.asGenericScimResource();
        patch.apply(genericScimResource);
        UserResource patchedUser = (UserResource)this._mapper.readValue(genericScimResource.getObjectNode().toString(), UserResource.class);
        DbProfile persistedProfile = (DbProfile)this._profileRepo.save((Object)DbProfile.toDbProfile((Long)((DbProfile)dbProfile.get()).getId(), (UUID)uuid, (UserResource)patchedUser));
        List patchedMemberships = ScimUsersService.getGroups((UUID)uuid, (UserResource)patchedUser);
        if (patchedMemberships != null) {
            this._groupMemberRepo.deleteAllById_UserGroupId(uuid);
            persistedMemberships = this._groupMemberRepo.saveAll((Iterable)patchedMemberships);
        } else {
            persistedMemberships = List.of();
        }
        return ScimUsersService.toUserResource((DbProfile)persistedProfile, persistedMemberships);
    }

    @Nonnull
    @Transactional
    public UserResource replace(UUID uuid, UserResource user) throws ResourceNotFoundException, PreconditionFailedException {
        List persistedMemberships;
        Optional foundProfile = this._profileRepo.findById((Object)uuid);
        if (foundProfile.isEmpty()) {
            throw ScimUsersService.userNotFound((UUID)uuid);
        }
        DbProfile dbProfile = DbProfile.toDbProfile((Long)((DbProfile)foundProfile.get()).getId(), (UUID)uuid, (UserResource)user);
        List memberships = ScimUsersService.getGroups((UUID)uuid, (UserResource)user);
        DbProfile persistedProfile = (DbProfile)this._profileRepo.save((Object)dbProfile);
        if (memberships != null) {
            this._groupMemberRepo.deleteAllById_UserGroupId(uuid);
            persistedMemberships = this._groupMemberRepo.saveAll((Iterable)memberships);
        } else {
            persistedMemberships = List.of();
        }
        this._groupMemberRepo.deleteAllById_ProfileId(uuid);
        return ScimUsersService.toUserResource((DbProfile)persistedProfile, (List)persistedMemberships);
    }

    @Transactional
    public void delete(UUID uuid) {
        this._groupMemberRepo.deleteAllById_ProfileId(uuid);
        this._profileRepo.deleteById((Object)uuid);
    }

    @CheckForNull
    private String getFilterValue(SearchRequest searchRequest) throws NotImplementedException, BadRequestException {
        String stringFilter = searchRequest.getFilter();
        if (stringFilter.isEmpty()) {
            return null;
        }
        String filterValue = null;
        Filter filter = Filter.fromString((String)stringFilter);
        if (filter != null && filter.getFilterType() == FilterType.EQUAL) {
            ValueNode comparisonValue = filter.getComparisonValue();
            if (comparisonValue.textValue().isEmpty()) {
                throw new NotImplementedException("Only equals filter supported");
            }
            filterValue = comparisonValue.textValue();
        }
        return filterValue == null ? null : URLDecoder.decode(filterValue, StandardCharsets.UTF_8);
    }

    @CheckForNull
    private static List<DbUserGroupMember> getGroups(UUID profileId, UserResource user) {
        List groups = user.getGroups();
        return groups == null ? null : groups.stream().map(group -> new DbUserGroupMember(new DbUserGroupMemberId(profileId, UUID.fromString(group.getValue())), Instant.now(), ImportMethod.SCIM)).toList();
    }

    @Nonnull
    private static UserResource toUserResource(DbProfile profile, List<DbUserGroupMember> memberships) {
        Name name = new Name();
        name.setGivenName(profile.getFirstName());
        name.setFamilyName(profile.getLastName());
        Email email = new Email();
        email.setValue(profile.getEmail());
        email.setType("work");
        email.setPrimary(Boolean.valueOf(true));
        UserResource user = new UserResource();
        user.setId(profile.getUuid().toString());
        user.setName(name);
        user.setActive(Boolean.valueOf(profile.isActive()));
        user.setEmails(List.of(email));
        user.setUserName(profile.getEmail());
        user.setGroups(memberships.stream().map(membership -> new Group().setValue(membership.getId().getUserGroupId().toString())).toList());
        return user;
    }

    @Nonnull
    private static ResourceNotFoundException userNotFound(UUID id) {
        return new ResourceNotFoundException(String.format("User with id %s not found", id));
    }
}

