/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.domain.login.UserLogin;
import de.justsoftware.gateway.domain.login.UserLoginRepository;
import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.ids.TenantId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
@ParametersAreNonnullByDefault
public class UserLoginService {
    private final UserLoginRepository _userLoginRepository;

    public UserLoginService(UserLoginRepository userLoginRepository) {
        this._userLoginRepository = userLoginRepository;
    }

    @Nonnull
    public Mono<UserLogin> saveLogin(ProfileId profileId, TenantId tenantId, OAuth2AuthenticationToken token) {
        OAuth2User principal = token.getPrincipal();
        if (principal instanceof OidcUser) {
            OidcUser oidcUser = (OidcUser)principal;
            OidcIdToken idToken = oidcUser.getIdToken();
            String tokenValue = idToken.getTokenValue();
            UserLogin userLogin = UserLogin.builder().profileId(profileId).tenantId(tenantId).registrationId(token.getAuthorizedClientRegistrationId()).idToken(tokenValue).build();
            return this._userLoginRepository.save((Object)userLogin);
        }
        return Mono.empty();
    }
}

