/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.security.JustJwtProperties;
import de.justsoftware.jwtfilter.JwtClaimsHolder;
import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import java.time.Duration;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public final class AuthenticationToJwtStringConverter
implements Converter<JustAuthToken, String> {
    public static final String LOGIN_ID = "login_id";
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationToJwtStringConverter.class);
    private static final String TENANT_ID_KEY = "tenantId";
    private final long _tokenLifetime;
    private final JwtGenerator _jwtGenerator;
    private final LoadingCache<JwtCacheKey, String> _jwtCache;

    public AuthenticationToJwtStringConverter(JwtGenerator jwtGenerator, JustJwtProperties jwtProperties) {
        this._jwtGenerator = jwtGenerator;
        this._jwtCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).refreshAfterWrite(Duration.ofMinutes(5L)).maximumSize(10000L).build(arg_0 -> this.generateJwt(arg_0));
        this._tokenLifetime = jwtProperties.getCookie().getCookieLifetime().toMinutes();
    }

    public String convert(JustAuthToken authentication) {
        return (String)this._jwtCache.get((Object)new JwtCacheKey(authentication));
    }

    @CheckForNull
    private String generateJwt(JwtCacheKey key) {
        try {
            JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder().withSubject(((Long)key._profileId.getId()).toString()).withLifetime(this._tokenLifetime);
            if (key._tenantId != null) {
                claimsBuilder.withCustomClaim(TENANT_ID_KEY, key._tenantId.asString());
            }
            if (key._userLoginId != null) {
                claimsBuilder.withCustomClaim(LOGIN_ID, key._userLoginId.toUUIDString());
            }
            return this._jwtGenerator.generateJWT(claimsBuilder);
        }
        catch (JwtKeyLoadingException | JoseException e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    @Nonnull
    public String generateRefreshedJwt(JwtClaimsHolder authenticatingToken) throws IllegalStateException {
        JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder();
        try {
            String authenticatedId = this.extractNumericProfileId(authenticatingToken);
            claimsBuilder.withSubject(authenticatedId).withLifetime(this._tokenLifetime);
            for (Map.Entry claim : authenticatingToken.getCustomJwtClaims().entrySet()) {
                claimsBuilder.withCustomClaim((String)claim.getKey(), claim.getValue().toString());
            }
            return this._jwtGenerator.generateJWT(claimsBuilder);
        }
        catch (JwtKeyLoadingException | IndexOutOfBoundsException | JoseException e) {
            throw new IllegalStateException("Could not generate new token.", e);
        }
    }

    @Nonnull
    private String extractNumericProfileId(JwtClaimsHolder authenticatingToken) {
        return authenticatingToken.getSubject().split(",")[1];
    }
}

