/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.ids;

import com.fasterxml.jackson.annotation.JsonCreator;
import de.justsoftware.gateway.ids.core.AbstractUUIDBasedItemId;
import de.justsoftware.gateway.ids.core.IdParser;
import de.justsoftware.gateway.ids.core.ItemType;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TenantId
extends AbstractUUIDBasedItemId {
    private static final long serialVersionUID = 1L;

    public TenantId(UUID id) {
        super(id, ItemType.TENANT);
    }

    @Nonnull
    public static TenantId random() {
        return new TenantId(UUID.randomUUID());
    }

    @JsonCreator
    @Nonnull
    public static TenantId parse(String tenantId) {
        return (TenantId)IdParser.parse((ItemType)ItemType.TENANT, (String)tenantId, s -> new TenantId(UUID.fromString(s)));
    }
}

