/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import de.justsoftware.drive.business.common.PreviewAccessTokenService;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.file.FilePreviewService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.preview.CropStrategy;
import de.justsoftware.drive.business.preview.ImagePreviewOptions;
import de.justsoftware.drive.business.preview.ImagePreviewOptionsImpl;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FilePreviewByteSource;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.rest.controllers.FilePreviewController;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.toolbox.http.ContentDispositionUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/api/unauthenticated"})
@Schema(description="Unauthenticated File Previews")
@ParametersAreNonnullByDefault
public class UnauthenticatedFilePreviewController {
    private static final String REQUESTED_FILE_WAS_NOT_FOUND = "Requested file was not found";
    private final RestTemplate _restTemplate;
    private final FileService _fileService;
    private final FilePreviewService _previewService;
    private final PreviewAccessTokenService _previewAccessTokenService;
    private final DocumentService _documentService;

    @Autowired
    public UnauthenticatedFilePreviewController(@Qualifier(value="driveFilePersistenceRestTemplate") RestTemplate restTemplate, FilePreviewService previewService, FileService fileService, PreviewAccessTokenService previewAccessTokenService, DocumentService documentService) {
        this._restTemplate = restTemplate;
        this._previewService = previewService;
        this._fileService = fileService;
        this._previewAccessTokenService = previewAccessTokenService;
        this._documentService = documentService;
    }

    @Operation(description="Binary content of the requested video.")
    @RequestMapping(value={"/previewVideoFile/{jwtEncodedFileVersionId}"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> previewForVideoFile(HttpServletResponse response, @PathVariable String jwtEncodedFileVersionId) {
        DocumentVersionId fileVersionId = this._previewAccessTokenService.extractFileVersionId(jwtEncodedFileVersionId);
        this.checkDocumentNotDeleted(fileVersionId);
        FileVersionBO fileVersion = this._fileService.getSingleVersionById(fileVersionId);
        if (fileVersion == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        String videoPreviewUrl = this._previewService.getConvertedVideoUrl(fileVersionId);
        ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)fileVersion.getName());
        return this._restTemplate.exchange(videoPreviewUrl, HttpMethod.GET, null, Resource.class, new Object[0]);
    }

    @Operation(description="Returns the binary content of the preview image for the requested document version. Keeps aspect ratio.")
    @RequestMapping(value={"/previewImage/{jwtEncodedFileVersionId}"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> previewImageForVideoFile(@PathVariable String jwtEncodedFileVersionId, @RequestParam(required=false, defaultValue="1920") int width, @RequestParam(required=false, defaultValue="1080") int height) {
        try {
            DocumentVersionId fileVersion = this._previewAccessTokenService.extractFileVersionId(jwtEncodedFileVersionId);
            this.checkDocumentNotDeleted(fileVersion);
            ImagePreviewOptionsImpl previewOptions = ImagePreviewOptionsImpl.Builder.gifAsOriginal((int)width, (int)height).cropStrategy(CropStrategy.KEEP_ASPECT_RATIO).build();
            return FilePreviewController.wrapResource((FilePreviewByteSource)this._previewService.getImage(fileVersion, (ImagePreviewOptions)previewOptions));
        }
        catch (IOException e) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
    }

    private void checkDocumentNotDeleted(DocumentVersionId documentVersion) throws UnknownResourceException {
        boolean deleted = this._documentService.isDeleted(documentVersion, PublishedFilter.ONLY_PUBLISHED);
        if (deleted) {
            throw new UnknownResourceException("The document version " + documentVersion + " was deleted.");
        }
    }
}

