/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.sync;

import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.sync.model.FileSyncUsageBO;
import de.justsoftware.drive.persistence.sync.FileSyncDAO;
import de.justsoftware.drive.persistence.sync.FileSyncMapper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class FileSyncDAOImpl
implements FileSyncDAO {
    private final FileSyncMapper _fileSyncMapper;

    public FileSyncDAOImpl(FileSyncMapper fileSyncMapper) {
        this._fileSyncMapper = fileSyncMapper;
    }

    public void markSyncappUsed(PersonId personId, DocumentVersionId versionId, DateTime downloadDate) {
        this._fileSyncMapper.insertUsage(personId, versionId, downloadDate);
        this._fileSyncMapper.updateUsage(personId, versionId, downloadDate);
    }

    public FileSyncUsageBO getLastFileSyncUsage(PersonId personId) {
        List usages = this._fileSyncMapper.getUsage(personId);
        return usages.isEmpty() ? null : (FileSyncUsageBO)usages.get(0);
    }
}

