/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.justsoftware.drive.common.file.model.TempFileBO;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.file.TempFileCreateModel;
import de.justsoftware.drive.persistence.file.TempFileDAO;
import de.justsoftware.drive.persistence.file.TempFileMapper;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.session.RowBounds;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class TempFileDAOImpl
implements TempFileDAO {
    private final TempFileMapper _tempFileMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public TempFileDAOImpl(TempFileMapper tempFileMapper, DAOSupport daoSupport) {
        this._tempFileMapper = tempFileMapper;
        this._daoSupport = daoSupport;
    }

    public TempFileCreateModel tempFileCreateModel() {
        return new TempFileCreateModel();
    }

    public void insertTempFiles(Iterable<TempFileCreateModel> models) {
        models.forEach(arg_0 -> ((TempFileMapper)this._tempFileMapper).insertTempFile(arg_0));
    }

    public ImmutableMap<TempFileId, TempFileBO> getByIds(Set<TempFileId> ids) {
        return (ImmutableMap)this._daoSupport.partition(ids).index(TempFileBO::getId).asMap().query((arg_0, arg_1) -> ((TempFileMapper)this._tempFileMapper).getByIds(arg_0, arg_1));
    }

    public void deleteTempFiles(Set<TempFileId> tempFileIds) {
        this._daoSupport.partition(tempFileIds).noResult(arg_0 -> ((TempFileMapper)this._tempFileMapper).deleteByIds(arg_0));
    }

    public ImmutableMap<TempFileId, TempFileBO> getOlderThan(int chunkSize, DateTime date) {
        return Maps.uniqueIndex((Iterable)this._tempFileMapper.getOlderThan(date, new RowBounds(0, chunkSize)), TempFileBO::getId);
    }
}

