/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.file.model.FileLockBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.file.FileLockDAO;
import de.justsoftware.drive.persistence.file.FileLockMapper;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class FileLockDAOImpl
implements FileLockDAO {
    private final FileLockMapper _fileLockMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public FileLockDAOImpl(FileLockMapper fileLockMapper, DAOSupport daoSupport) {
        this._fileLockMapper = fileLockMapper;
        this._daoSupport = daoSupport;
    }

    public void lockFile(DocumentId fileId, PersonId owner, DateTime lockDate) {
        this._fileLockMapper.insertLock(fileId, owner, lockDate);
    }

    public void release(DocumentId fileId) {
        this._fileLockMapper.deleteLock(fileId);
    }

    public ImmutableMap<DocumentId, FileLockBO> getLocks(Set<DocumentId> fileIds) {
        return (ImmutableMap)this._daoSupport.partition(fileIds).index(FileLockBO::getFileId).asMap().query((arg_0, arg_1) -> ((FileLockMapper)this._fileLockMapper).getLocks(arg_0, arg_1));
    }
}

