/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.document.ItemLockService;
import de.justsoftware.drive.business.document.NameValidation;
import de.justsoftware.drive.business.document.impl.NonLockingDocumentTreeModificationService;
import de.justsoftware.drive.business.migrationwiki.document.NonLockingWikiMigrationDocumentTreeModificationService;
import de.justsoftware.drive.business.migrationwiki.document.WikiMigrationDocumentTreeModificationService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileInfo;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class LockingDocumentTreeModificationServiceImpl
implements DocumentTreeModificationService,
WikiMigrationDocumentTreeModificationService {
    private final NonLockingDocumentTreeModificationService _delegate;
    private final NonLockingWikiMigrationDocumentTreeModificationService _wikiMigrationDelegate;
    private final ItemLockService _itemLockService;

    @Autowired
    public LockingDocumentTreeModificationServiceImpl(NonLockingDocumentTreeModificationService delegate, ItemLockService itemLockService, NonLockingWikiMigrationDocumentTreeModificationService migrationDelegate) {
        this._delegate = delegate;
        this._itemLockService = itemLockService;
        this._wikiMigrationDelegate = migrationDelegate;
    }

    public void createRootFolders(Map<ItemId, PersonId> owner, String purpose) {
        this._delegate.createRootFolders(owner, purpose);
    }

    public ImmutableListMultimap<DocumentId, FileVersionBO> rollbackFiles(Set<DocumentId> fileIds) {
        return this._delegate.rollbackFiles(fileIds);
    }

    public FolderVersionBO addSubFolder(DocumentId parent, String childName, PersonId owner) {
        return (FolderVersionBO)this._itemLockService.acquireAndExecute(parent, () -> this._delegate.addSubFolder(parent, childName, owner));
    }

    public ImmutableMap<DocumentVersionId, ByteSourceWithFilename> addFiles(DocumentId parent, Iterable<ByteSourceWithFilename> sources, PersonId owner, String purpose, NameValidation nameValidation) {
        return (ImmutableMap)this._itemLockService.acquireAndExecute(parent, () -> this._delegate.addFiles(parent, sources, owner, purpose, nameValidation));
    }

    public DocumentVersionId addEmptyFile(DocumentId parent, String name, PersonId owner, String purpose, NameValidation nameValidation) {
        return (DocumentVersionId)this._itemLockService.acquireAndExecute(parent, () -> this._delegate.addEmptyFile(parent, name, owner, purpose, nameValidation));
    }

    public ImmutableMap<StorageId, FileVersionBO> addFileInfos(DocumentId parent, Iterable<FileInfo> sources, PersonId owner, String purpose) {
        return (ImmutableMap)this._itemLockService.acquireAndExecute(parent, () -> this._delegate.addFileInfos(parent, sources, owner, purpose));
    }

    public DocumentVersionId deleteDocument(DocumentId documentId, PersonId owner) {
        return (DocumentVersionId)this._itemLockService.acquireAndExecute(documentId, () -> this._delegate.deleteDocument(documentId, owner));
    }

    public FileVersionBO renameFile(DocumentId fileId, PersonId personId, String newName) {
        return (FileVersionBO)this._itemLockService.acquireAndExecute(fileId, () -> this._delegate.renameFile(fileId, personId, newName));
    }

    public FolderVersionBO renameFolder(DocumentId folderId, PersonId personId, String newName) {
        return (FolderVersionBO)this._itemLockService.acquireAndExecute(folderId, () -> this._delegate.renameFolder(folderId, personId, newName));
    }

    public FileVersionBO uploadNewFileVersion(DocumentId fileId, ByteSourceWithFilename source, PersonId owner, String purpose) {
        return (FileVersionBO)this._itemLockService.acquireAndExecute(fileId, () -> this._delegate.uploadNewFileVersion(fileId, source, owner, purpose));
    }

    public ChangeBO restoreVersion(DocumentVersionId change, PersonId actor, String purpose) {
        return (ChangeBO)((Optional)this._itemLockService.acquireAndExecute(change, () -> Optional.fromNullable((Object)this._delegate.restoreVersion(change, actor, purpose)))).orNull();
    }

    public void moveToFolder(DocumentId targetFolderId, Set<DocumentId> documents, PersonId personId) {
        this._itemLockService.acquireAndExecute(targetFolderId, () -> {
            this._delegate.moveToFolder(targetFolderId, documents, personId);
            return this;
        });
    }

    public void copyToFolder(DocumentId targetFolderId, Map<DocumentId, PublishedFilter> documents, PersonId personId) {
        this._itemLockService.acquireAndExecute(targetFolderId, () -> {
            this._delegate.copyToFolder(targetFolderId, documents, personId);
            return this;
        });
    }

    public DocumentId copyToNewRoot(DocumentId sourceDocumentId, DocumentId targetFolderId) {
        return (DocumentId)this._itemLockService.acquireAndExecute(targetFolderId, () -> this._wikiMigrationDelegate.copyToNewRoot(sourceDocumentId, targetFolderId));
    }
}

