/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.common.document.model.DocumentBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DocumentServiceImpl
implements DocumentService {
    private final DocumentVersionDAO _documentVersionDAO;
    private final DocumentDAO _documentDAO;
    private final FolderService _folderService;
    private final ItemReadService _itemService;

    @Autowired
    public DocumentServiceImpl(DocumentVersionDAO documentVersionDAO, DocumentDAO documentDAO, FolderService folderService, ItemReadService itemService) {
        this._documentVersionDAO = documentVersionDAO;
        this._documentDAO = documentDAO;
        this._folderService = folderService;
        this._itemService = itemService;
    }

    public ImmutableMap<DocumentVersionId, DocumentId> getDocumentIdsOfVersions(Set<DocumentVersionId> ids) {
        return this._documentVersionDAO.getDocumentIdsOfVersions(ids);
    }

    public DocumentBO getDocument(DocumentId id) {
        return (DocumentBO)this._documentDAO.getDocumentsById((Set)ImmutableSet.of((Object)id)).get((Object)id);
    }

    public ImmutableMap<DocumentId, DocumentBO> getDocumentsById(Set<DocumentId> ids) {
        return this._documentDAO.getDocumentsById(ids);
    }

    public boolean isDeleted(DocumentId documentId, PublishedFilter publishedFilter) {
        ItemId parent = (ItemId)this._documentVersionDAO.getItemIdsOfDocument(Set.of(documentId)).get((Object)documentId);
        if (parent == null) {
            return true;
        }
        ItemBO itemBO = (ItemBO)this._itemService.getItems(Set.of(parent)).get((Object)parent);
        if (itemBO != null && itemBO.isDeleted()) {
            return true;
        }
        return this._folderService.getCurrentVersionsOfDocuments(Set.of(documentId), publishedFilter).isEmpty();
    }

    public boolean isDeleted(DocumentVersionId documentVersionId, PublishedFilter publishedFilter) {
        DocumentId documentId = (DocumentId)this._documentVersionDAO.getDocumentIdsOfVersions(Set.of(documentVersionId)).get((Object)documentVersionId);
        if (documentId == null) {
            return true;
        }
        return this.isDeleted(documentId, publishedFilter);
    }
}

