/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.business.document.DocumentPublicity;
import de.justsoftware.drive.business.document.DocumentPublisher;
import de.justsoftware.drive.business.document.impl.DocumentPublisherImpl;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.file.DocumentSupportDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DocumentPublisherImpl
implements DocumentPublisher {
    @VisibleForTesting
    static final String TOPIC = "just.drive.documents";
    @VisibleForTesting
    static final String NAME = "name";
    @VisibleForTesting
    static final String VERSION_ID = "versionId";
    @VisibleForTesting
    static final String MIME_TYPE = "mimeType";
    @VisibleForTesting
    static final String FILE_SIZE = "fileSize";
    @VisibleForTesting
    static final String ITEM_ID = "itemId";
    @VisibleForTesting
    static final String CHANGE_DATE = "changeDate";
    private static final String FOLDER_MIME_TYPE = "inode/directory";
    private static final Logger LOG = LoggerFactory.getLogger(DocumentPublisherImpl.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final DocumentDAO _documentDAO;
    private final DocumentSupportDAO _documentSupportDAO;
    private final SubFolderDAO _subFolderDAO;
    private final ChangeDAO _changeDAO;
    private final ItemReadService _itemReadService;
    private final Producer<String, String> _kafkaProducer;

    @Autowired
    public DocumentPublisherImpl(DocumentDAO documentDAO, DocumentSupportDAO documentSupportDAO, SubFolderDAO subFolderDAO, ChangeDAO changeDAO, ItemReadService itemReadService, @Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> kafkaProducer) {
        this._documentDAO = documentDAO;
        this._documentSupportDAO = documentSupportDAO;
        this._subFolderDAO = subFolderDAO;
        this._changeDAO = changeDAO;
        this._itemReadService = itemReadService;
        this._kafkaProducer = kafkaProducer;
    }

    private void send(ToroDocumentItem doc, Set<DocumentPublicity> publicities) {
        ObjectNode jsonNode = OBJECT_MAPPER.createObjectNode();
        jsonNode.set(NAME, (JsonNode)TextNode.valueOf((String)doc.getName()));
        Long fileSize = doc.getFileSize();
        if (fileSize != null) {
            jsonNode.set(FILE_SIZE, (JsonNode)LongNode.valueOf((long)fileSize));
        }
        jsonNode.set(MIME_TYPE, (JsonNode)TextNode.valueOf((String)doc.getMimeType()));
        jsonNode.set(CHANGE_DATE, (JsonNode)TextNode.valueOf((String)ISODateTimeFormat.dateTime().print((ReadableInstant)doc.getChangeDate())));
        jsonNode.set(ITEM_ID, (JsonNode)TextNode.valueOf((String)((String)doc.getItemId().getId())));
        try {
            this.send(doc.getDocumentId(), publicities, OBJECT_MAPPER.writeValueAsString((Object)jsonNode));
        }
        catch (JsonProcessingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void publishDocument(DocumentVersionBO doc, Set<DocumentPublicity> publicities) {
        if (!doc.isRoot()) {
            this.send((ToroDocumentItem)new /* Unavailable Anonymous Inner Class!! */, publicities);
        }
    }

    public void deleteDocument(DocumentId documentId, Set<DocumentPublicity> publicity) {
        this.send(documentId, publicity, null);
    }

    private void send(DocumentId documentId, Set<DocumentPublicity> publicities, @Nullable String value) {
        if (this._kafkaProducer == null) {
            return;
        }
        for (DocumentPublicity publicity : publicities) {
            this._kafkaProducer.send(new ProducerRecord(TOPIC, (Object)(documentId.toUUIDString() + ";" + publicity), (Object)value), (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
        }
    }

    private void logErrorCallback(RecordMetadata metadata, @Nullable Exception exception) {
        if (exception != null) {
            LOG.error("Could not file to topic just.drive.documents", (Throwable)exception);
        }
    }

    public void publishAllItems() {
        if (this._kafkaProducer == null) {
            throw new IllegalStateException("kafka producer is not ready");
        }
        this._itemReadService.forAllItemsWithDocuments(10, items -> this.publishItems((Set)ImmutableSet.copyOf((Collection)items)));
    }

    public void publishItems(Set<ItemId> items) {
        this.publishItems(items, (Map)this._changeDAO.getNewestChangePerItem(items, PublishedFilter.ONLY_PUBLISHED), (Set)ImmutableSet.of((Object)DocumentPublicity.PUBLIC));
        this.publishItems(items, (Map)this._changeDAO.getNewestChangePerItem(items, PublishedFilter.PUBLISHED_OR_PRIVATE), (Set)ImmutableSet.of((Object)DocumentPublicity.PRIVATE));
    }

    public void publishItems(Set<ItemId> itemIds, Map<ItemId, ChangeBO> newestChanges, Set<DocumentPublicity> publicities) {
        if (this._kafkaProducer == null) {
            return;
        }
        ImmutableSet deletedItems = (ImmutableSet)this._itemReadService.getItems(itemIds).values().stream().filter(ItemBO::isDeleted).map(ItemBO::getId).collect(ImmutableSet.toImmutableSet());
        HashSet handledDocuments = new HashSet();
        HashSet<DocumentVersionId> queue = new HashSet<DocumentVersionId>();
        HashSet documentsToDelete = new HashSet(this._documentDAO.getDocumentIdsPerItems(itemIds).inverse().keySet());
        for (ItemId itemId : itemIds) {
            ChangeBO change = newestChanges.get(itemId);
            if (change == null || !change.isPublic()) continue;
            queue.add(change.getDocumentVersionId());
        }
        while (!queue.isEmpty()) {
            handledDocuments.addAll(queue);
            ImmutableMap documents = this._documentSupportDAO.getDocumentVersionsByIds(queue);
            documents.forEach((id, doc) -> {
                if (!deletedItems.contains((Object)doc.getItemId())) {
                    documentsToDelete.remove(doc.getDocumentId());
                    this.publishDocument(doc, publicities);
                }
            });
            ImmutableSetMultimap children = this._subFolderDAO.getSubFoldersByIds((Set)documents.values().stream().filter(FolderVersionBO.class::isInstance).map(DocumentVersionBO::getId).collect(ImmutableSet.toImmutableSet()));
            queue.clear();
            queue.addAll((Collection<DocumentVersionId>)children.inverse().keySet());
            queue.removeAll(handledDocuments);
        }
        documentsToDelete.forEach(d -> this.deleteDocument(d, publicities));
    }
}

