/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.change;

import com.google.common.base.MoreObjects;
import de.justsoftware.drive.business.change.ChangeTrigger;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.toolbox.model.AbstractImmutableEqualsObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class NewFileTrigger
extends AbstractImmutableEqualsObject
implements ChangeTrigger {
    private final DocumentId _documentId;
    private final DocumentVersionId _versionId;
    private final String _newName;
    private final long _fileSize;
    private final int _version;
    private final PersonId _owner;
    private final DateTime _changeDate;
    private final String _mimeType;

    public NewFileTrigger(FileVersionBO fileVersion) {
        this(fileVersion.getDocumentId(), fileVersion.getId(), fileVersion.getName(), fileVersion.getFileSize(), fileVersion.getMimeType(), fileVersion.getVersion(), fileVersion.getOwner(), fileVersion.getChangeDate());
    }

    public NewFileTrigger(DocumentId documentId, DocumentVersionId versionId, String newName, long fileSize, String mimeType, int version, PersonId owner, DateTime changeDate) {
        super(new Object[]{documentId, versionId, newName, fileSize, mimeType, version});
        this._documentId = documentId;
        this._versionId = versionId;
        this._newName = newName;
        this._fileSize = fileSize;
        this._mimeType = mimeType;
        this._version = version;
        this._owner = owner;
        this._changeDate = changeDate;
    }

    @Nonnull
    public DocumentId getDocumentId() {
        return this._documentId;
    }

    @Nonnull
    public DocumentVersionId getVersionId() {
        return this._versionId;
    }

    @Nonnull
    public String getNewName() {
        return this._newName;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    @Nonnull
    public String getMimeType() {
        return this._mimeType;
    }

    public int getVersion() {
        return this._version;
    }

    @Nonnull
    public PersonId getOwner() {
        return this._owner;
    }

    @Nonnull
    public DateTime getChangeDate() {
        return this._changeDate;
    }

    public <T> T accept(ChangeTrigger.Visitor<T> visitor) {
        return (T)visitor.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("documentId", (Object)this._documentId).add("versionId", (Object)this._versionId).add("newName", (Object)this._newName).add("fileSize", this._fileSize).add("mimeType", (Object)this._mimeType).add("version", this._version).add("owner", (Object)this._owner).add("changeDate", (Object)this._changeDate).toString();
    }
}

