/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.search.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.batch.search.SearchVisibilityService;
import de.justsoftware.drive.batch.search.impl.SearchVisibilityServiceImpl;
import de.justsoftware.drive.business.authorization.AuthorizationService;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.ornot.BoolExpr;
import de.justsoftware.ornot.EvalContext;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.toolbox.stream.EntryCollectors;
import de.justsoftware.toolbox.stream.EntryStream;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchVisibilityServiceImpl
implements SearchVisibilityService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchVisibilityServiceImpl.class);
    @VisibleForTesting
    final AuthorizationService _authorizationService;
    @VisibleForTesting
    final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public SearchVisibilityServiceImpl(AuthorizationService authorizationService, PermissionRequestConnector permissionRequestConnector) {
        this._authorizationService = authorizationService;
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public ImmutableTable<ItemId, StaticAction, ImmutableSet<Role>> loadVisibilities(SetMultimap<ItemId, StaticAction> itemsAndActions) {
        ImmutableSetMultimap visibilitiesFromPermission = this.loadVisibilitiesFromPermission(itemsAndActions);
        SetMultimap legacyItemsAndActions = Multimaps.filterKeys(itemsAndActions, itemId -> itemId.getType().usesLegacyPermissions());
        ImmutableTable legacyPermissions = this._authorizationService.loadPermissions(legacyItemsAndActions);
        ImmutableSet.Builder rolesToLoad = ImmutableSet.builder();
        EvalContext rolesCollectContext = expr -> {
            rolesToLoad.add((Object)((Role)expr.getValue()));
            return expr;
        };
        legacyPermissions.values().forEach(p -> p.eval(rolesCollectContext));
        ImmutableSetMultimap personsWithRoles = this._authorizationService.getPersonWithRoles((Set)rolesToLoad.build());
        ItemRolesToProfileRolesEvalContext itemRolesToProfileRolesEvalContext = new ItemRolesToProfileRolesEvalContext(personsWithRoles);
        return (ImmutableTable)EntryStream.from(itemsAndActions).collect(ImmutableTable.toImmutableTable(Map.Entry::getKey, Map.Entry::getValue, arg_0 -> SearchVisibilityServiceImpl.lambda$loadVisibilities$3(legacyPermissions, (EvalContext)itemRolesToProfileRolesEvalContext, visibilitiesFromPermission, arg_0)));
    }

    @Nonnull
    private ImmutableSetMultimap<ItemId, Role> loadVisibilitiesFromPermission(SetMultimap<ItemId, StaticAction> itemsAndActions) {
        ImmutableSet permissionRelatedActions = (ImmutableSet)EntryStream.from(itemsAndActions).filterKey(itemId -> !itemId.getType().usesLegacyPermissions()).filterValue(arg_0 -> StaticAction.DOCUMENT_READ.equals(arg_0)).mapKey(AbstractId::getId).keys().collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap visibilities = this._permissionRequestConnector.visibility((Iterable)permissionRelatedActions);
        return (ImmutableSetMultimap)EntryStream.from((Multimap)visibilities).mapKey(ItemId::new).mapValue(Role::valueOf).collect(EntryCollectors.toImmutableSetMultimap());
    }

    private static /* synthetic */ ImmutableSet lambda$loadVisibilities$3(ImmutableTable legacyPermissions, EvalContext itemRolesToProfileRolesEvalContext, ImmutableSetMultimap visibilitiesFromPermission, Map.Entry entry) {
        ItemId itemId = (ItemId)entry.getKey();
        StaticAction action = (StaticAction)entry.getValue();
        if (itemId.getType().usesLegacyPermissions()) {
            BoolExpr noItemRolesExpr = (BoolExpr)legacyPermissions.get((Object)itemId, (Object)action);
            if (noItemRolesExpr != null) {
                return (ImmutableSet)noItemRolesExpr.eval(itemRolesToProfileRolesEvalContext).accept((BoolExpr.Visitor)new ExtractRoleSetVisitor(noItemRolesExpr, itemId));
            }
        } else if (StaticAction.DOCUMENT_READ.equals((Object)action)) {
            return visibilitiesFromPermission.get((Object)itemId);
        }
        return ImmutableSet.of();
    }
}

