/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.justsoftware.jdoc.services.exceptions.InvalidDocumentIdException;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DocumentId {
    private final UUID _uuid;

    public DocumentId() {
        this(UUID.randomUUID());
    }

    public DocumentId(UUID uuid) {
        this._uuid = uuid;
    }

    @JsonCreator
    public DocumentId(@JsonProperty(value="id") String idString) throws InvalidDocumentIdException {
        try {
            this._uuid = UUID.fromString(idString);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidDocumentIdException("Id " + idString + " is not a valid document id!");
        }
    }

    @Nonnull
    public UUID toUniqueId() {
        return this._uuid;
    }

    @JsonProperty(value="id")
    public String toString() {
        return this.toUniqueId().toString();
    }

    @Nonnull
    public static DocumentId fromString(String idString) throws InvalidDocumentIdException {
        return new DocumentId(idString);
    }
}

