/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.util;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\t\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/chat/util/PeriodicAndSkipMissedTrigger;", "Lorg/springframework/scheduling/Trigger;", "period", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "", "(J)V", "getPeriod", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "nextExecution", "Ljava/time/Instant;", "triggerContext", "Lorg/springframework/scheduling/TriggerContext;", "toString", "", "chat-service"})
final class PeriodicAndSkipMissedTrigger
implements Trigger {
    private final long period;

    public PeriodicAndSkipMissedTrigger(long period) {
        this.period = period;
    }

    public final long getPeriod() {
        return this.period;
    }

    public PeriodicAndSkipMissedTrigger(@NotNull Duration period) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        this(period.toMillis());
    }

    @Nullable
    public Instant nextExecution(@NotNull TriggerContext triggerContext) {
        Intrinsics.checkNotNullParameter((Object)triggerContext, (String)"triggerContext");
        Instant lastExecution = triggerContext.lastScheduledExecution();
        Instant lastCompletion = triggerContext.lastCompletion();
        long nextExecution = lastExecution == null || lastCompletion == null ? triggerContext.getClock().millis() : Math.max(lastExecution.toEpochMilli() + this.period, lastCompletion.toEpochMilli());
        return Instant.ofEpochMilli(nextExecution);
    }

    public final long component1() {
        return this.period;
    }

    @NotNull
    public final PeriodicAndSkipMissedTrigger copy(long period) {
        return new PeriodicAndSkipMissedTrigger(period);
    }

    public static /* synthetic */ PeriodicAndSkipMissedTrigger copy$default(PeriodicAndSkipMissedTrigger periodicAndSkipMissedTrigger, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = periodicAndSkipMissedTrigger.period;
        }
        return periodicAndSkipMissedTrigger.copy(l);
    }

    @NotNull
    public String toString() {
        return "PeriodicAndSkipMissedTrigger(period=" + this.period + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.period);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PeriodicAndSkipMissedTrigger)) {
            return false;
        }
        PeriodicAndSkipMissedTrigger periodicAndSkipMissedTrigger = (PeriodicAndSkipMissedTrigger)other;
        return this.period == periodicAndSkipMissedTrigger.period;
    }
}

