/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.search;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.kafka.KafkaObjectMapper;
import de.justsoftware.chat.kafka.search.ChatCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.kafka.search.CommonCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.CommonCoreSearchFields;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.SearchId;
import de.justsoftware.chat.search.SolrIndexService;
import de.justsoftware.chat.util.CollectionUtilsKt;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 O2\u00020\u0001:\u0002OPBQ\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0012J\u0016\u0010$\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\"H\u0012J\b\u0010'\u001a\u00020(H\u0012J\"\u0010)\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020+0*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0-H\u0012JH\u0010.\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0\"0*2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020+0*2\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\"0*H\u0012J\"\u00103\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u0002050*2\f\u00106\u001a\b\u0012\u0004\u0012\u0002040-H\u0012J!\u00107\u001a\u00020 2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:09H\u0011\u00a2\u0006\u0002\b;J!\u0010<\u001a\u00020 2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:09H\u0011\u00a2\u0006\u0002\b=J\b\u0010>\u001a\u00020 H\u0016J\b\u0010?\u001a\u00020 H\u0016J\b\u0010@\u001a\u00020 H\u0016J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\"2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002050DH\u0012J\u001a\u0010E\u001a\u00020 *\u00020\u00172\f\u0010F\u001a\b\u0012\u0004\u0012\u00020B0\"H\u0012J\u001a\u0010G\u001a\u00020 *\u00020\u00172\f\u0010F\u001a\b\u0012\u0004\u0012\u00020B0\"H\u0012J\u001a\u0010H\u001a\u00020 *\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0-H\u0012J\u001a\u0010I\u001a\u00020 *\u00020\u00172\f\u0010J\u001a\b\u0012\u0004\u0012\u00020:0\"H\u0012J\u001a\u0010K\u001a\u00020 *\u00020\u00172\f\u0010J\u001a\b\u0012\u0004\u0012\u00020:0\"H\u0012J\u001a\u0010L\u001a\u0004\u0018\u00010&*\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:0MH\u0012J\u001e\u0010N\u001a\b\u0012\u0004\u0012\u00020#0\"*\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:0MH\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u00020\u00178\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u00020\u00178\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0019\u001a\u0004\b\u001e\u0010\u001bR\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lde/justsoftware/chat/search/SolrIndexService;", "", "commonCoreLeaderSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "chatCoreLeaderSolrClient", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "commonCoreSearchUpdateIndexProducer", "Lde/justsoftware/chat/kafka/search/CommonCoreSearchUpdateIndexProducer;", "chatCoreSearchUpdateIndexProducer", "Lde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lorg/apache/solr/client/solrj/SolrClient;Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/kafka/search/CommonCoreSearchUpdateIndexProducer;Lde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer;Lio/micrometer/core/instrument/MeterRegistry;)V", "chatCoreReindexThread", "Ljava/lang/Thread;", "chatSolrCore", "Lde/justsoftware/chat/search/SolrIndexService$SolrCore;", "getChatSolrCore$chat_service$annotations", "()V", "getChatSolrCore$chat_service", "()Lde/justsoftware/chat/search/SolrIndexService$SolrCore;", "commonSolrCore", "getCommonSolrCore$chat_service$annotations", "getCommonSolrCore$chat_service", "indexChatCore", "", "searchIds", "", "Lde/justsoftware/chat/model/SearchId;", "indexChatInCommonCore", "chatIdsToIndex", "Lde/justsoftware/chat/model/ChatId;", "isReindexingChatCore", "", "loadChats", "", "Lde/justsoftware/chat/business/model/Chat;", "chatIds", "", "loadOneOnOneChatPartners", "Lde/justsoftware/chat/business/model/Profile;", "chats", "chatParticipants", "Lde/justsoftware/chat/business/model/ChatParticipant;", "loadUserMessages", "Lde/justsoftware/chat/model/ChatMessageId;", "Lde/justsoftware/chat/business/model/UserMessage;", "chatMessageIds", "onIndexChatCore", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "onIndexChatCore$chat_service", "onIndexCommonCore", "onIndexCommonCore$chat_service", "reindexAll", "reindexChatCore", "reindexChatsInCommonCore", "toSolrInputDocuments", "Lorg/apache/solr/common/SolrInputDocument;", "userMessages", "", "addSolrDocuments", "documents", "addSolrDocumentsIndividually", "deleteByChatIds", "deleteSolrDocuments", "ids", "deleteSolrDocumentsIndividually", "getChatId", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "toSearchIds", "Companion", "SolrCore", "chat-service"})
@SourceDebugExtension(value={"SMAP\nSolrIndexService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/chat/search/SolrIndexService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ChatParticipant.kt\nde/justsoftware/chat/business/model/ChatParticipant$Companion\n+ 7 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 8 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,419:1\n1603#2,9:420\n1855#2:429\n1856#2:431\n1612#2:432\n1603#2,9:433\n1855#2:442\n1856#2:444\n1612#2:445\n1549#2:446\n1620#2,3:447\n1549#2:450\n1620#2,3:451\n809#2,2:455\n809#2,2:458\n1549#2:460\n1620#2,3:461\n1549#2:464\n1620#2,3:465\n1549#2:468\n1620#2,3:469\n1549#2:472\n1620#2,3:473\n1603#2,9:478\n1855#2:487\n1856#2:489\n1612#2:490\n1179#2,2:492\n1253#2,4:494\n800#2,11:505\n1620#2,3:517\n1603#2,9:520\n1855#2:529\n1856#2:531\n1612#2:532\n1549#2:534\n1620#2,3:535\n809#2,2:540\n1271#2,2:542\n1285#2,2:544\n1603#2,9:546\n1855#2:555\n1856#2:557\n1612#2:558\n1288#2:559\n1855#2,2:560\n1549#2:562\n1620#2,3:563\n1855#2,2:566\n1855#2,2:568\n1#3:430\n1#3:443\n1#3:488\n1#3:530\n1#3:556\n22#4:454\n22#4:457\n80#4,2:476\n82#4:491\n7#4:516\n22#4:539\n515#5:498\n500#5,6:499\n41#6:533\n42#6:538\n50#7:570\n43#7:571\n9#8:572\n8#8,3:573\n*S KotlinDebug\n*F\n+ 1 SolrIndexService.kt\nde/justsoftware/chat/search/SolrIndexService\n*L\n139#1:420,9\n139#1:429\n139#1:431\n139#1:432\n148#1:433,9\n148#1:442\n148#1:444\n148#1:445\n158#1:446\n158#1:447,3\n161#1:450\n161#1:451,3\n174#1:455,2\n175#1:458,2\n184#1:460\n184#1:461,3\n194#1:464\n194#1:465,3\n194#1:468\n194#1:469,3\n210#1:472\n210#1:473,3\n214#1:478,9\n214#1:487\n214#1:489\n214#1:490\n214#1:492,2\n214#1:494,4\n228#1:505,11\n229#1:517,3\n231#1:520,9\n231#1:529\n231#1:531\n231#1:532\n233#1:534\n233#1:535,3\n233#1:540,2\n235#1:542,2\n235#1:544,2\n238#1:546,9\n238#1:555\n238#1:557\n238#1:558\n235#1:559\n258#1:560,2\n287#1:562\n287#1:563,3\n289#1:566,2\n304#1:568,2\n139#1:430\n148#1:443\n214#1:488\n231#1:530\n238#1:556\n174#1:454\n175#1:457\n214#1:476,2\n214#1:491\n229#1:516\n233#1:539\n219#1:498\n219#1:499,6\n233#1:533\n233#1:538\n330#1:570\n330#1:571\n340#1:572\n340#1:573,3\n*E\n"})
public class SolrIndexService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient commonCoreLeaderSolrClient;
    @NotNull
    private final SolrClient chatCoreLeaderSolrClient;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final CommonCoreSearchUpdateIndexProducer commonCoreSearchUpdateIndexProducer;
    @NotNull
    private final ChatCoreSearchUpdateIndexProducer chatCoreSearchUpdateIndexProducer;
    @NotNull
    private final SolrCore commonSolrCore;
    @NotNull
    private final SolrCore chatSolrCore;
    @Nullable
    private Thread chatCoreReindexThread;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String CHAT_APP_ID = "CHAT";

    public SolrIndexService(@Qualifier(value="commonCoreLeaderSolrClient") @NotNull SolrClient commonCoreLeaderSolrClient, @Qualifier(value="chatCoreLeaderSolrClient") @NotNull SolrClient chatCoreLeaderSolrClient, @NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatMessageService chatMessageService, @NotNull ProfileService profileService, @NotNull CommonCoreSearchUpdateIndexProducer commonCoreSearchUpdateIndexProducer, @NotNull ChatCoreSearchUpdateIndexProducer chatCoreSearchUpdateIndexProducer, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)commonCoreLeaderSolrClient, (String)"commonCoreLeaderSolrClient");
        Intrinsics.checkNotNullParameter((Object)chatCoreLeaderSolrClient, (String)"chatCoreLeaderSolrClient");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)commonCoreSearchUpdateIndexProducer, (String)"commonCoreSearchUpdateIndexProducer");
        Intrinsics.checkNotNullParameter((Object)chatCoreSearchUpdateIndexProducer, (String)"chatCoreSearchUpdateIndexProducer");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.commonCoreLeaderSolrClient = commonCoreLeaderSolrClient;
        this.chatCoreLeaderSolrClient = chatCoreLeaderSolrClient;
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.chatMessageService = chatMessageService;
        this.profileService = profileService;
        this.commonCoreSearchUpdateIndexProducer = commonCoreSearchUpdateIndexProducer;
        this.chatCoreSearchUpdateIndexProducer = chatCoreSearchUpdateIndexProducer;
        this.commonSolrCore = new SolrCore("common", this.commonCoreLeaderSolrClient, meterRegistry);
        this.chatSolrCore = new SolrCore("chat", this.chatCoreLeaderSolrClient, meterRegistry);
    }

    @NotNull
    public SolrCore getCommonSolrCore$chat_service() {
        return this.commonSolrCore;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCommonSolrCore$chat_service$annotations() {
    }

    @NotNull
    public SolrCore getChatSolrCore$chat_service() {
        return this.chatSolrCore;
    }

    @VisibleForTesting
    public static /* synthetic */ void getChatSolrCore$chat_service$annotations() {
    }

    public void reindexAll() {
        this.commonCoreLeaderSolrClient.deleteByQuery(CommonCoreSearchFields.INSTANCE + ".JUST_APP_ID:CHAT");
        this.reindexChatsInCommonCore();
        this.reindexChatCore();
    }

    public void reindexChatsInCommonCore() {
        LOG.info("Start reindexing chats in common core...");
        this.commonCoreLeaderSolrClient.deleteByQuery("type:CHAT");
        LOG.info("Deleted all Solr documents of type CHAT in solr common core.");
        Ref.IntRef chatCount = new Ref.IntRef();
        CollectionUtilsKt.chunked((Stream)this.chatService.streamAllIds(), (int)1000).forEach(arg_0 -> SolrIndexService.reindexChatsInCommonCore$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        LOG.info("Filling common core index kafka topic finished...");
    }

    public void reindexChatCore() {
        if (this.isReindexingChatCore()) {
            LOG.info("Skip reindexing chat core, since a reindexing process is still alive...");
            return;
        }
        this.chatCoreReindexThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)31, null);
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="commonCoreSearchUpdateIndexConsumer", containerFactory="commonCoreSearchUpdateIndexConsumerFactory", topics={"just.chat-service.search.common.updateIndex"}, idIsGroup=false)
    public void onIndexCommonCore$chat_service(@NotNull ConsumerRecords<String, String> records) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable iterable = (Iterable)records;
        SolrIndexService solrIndexService = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChatId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ConsumerRecord it = (ConsumerRecord)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (this.getChatId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        solrIndexService.indexChatInCommonCore((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="chatCoreSearchUpdateIndexConsumer", containerFactory="chatCoreSearchUpdateIndexConsumerFactory", topics={"just.chat-service.search.chat.updateIndex"}, idIsGroup=false)
    public void onIndexChatCore$chat_service(@NotNull ConsumerRecords<String, String> records) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable iterable = (Iterable)records;
        SolrIndexService solrIndexService = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ConsumerRecord it = (ConsumerRecord)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (this.toSearchIds(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        solrIndexService.indexChatCore(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private void indexChatInCommonCore(List<ChatId> chatIdsToIndex) {
        Chat p0;
        Collection<SolrInputDocument> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (chatIdsToIndex.isEmpty()) {
            return;
        }
        Map chats2 = this.loadChats(CollectionsKt.toSet((Iterable)chatIdsToIndex));
        Map chatParticipants = this.chatParticipantService.findByChatIds((Iterable)chats2.keySet());
        Map chatPartners = this.loadOneOnOneChatPartners(chats2, chatParticipants);
        List idsToDeleted = CollectionsKt.minus((Iterable)chatIdsToIndex, (Iterable)chats2.keySet());
        Iterable iterable = idsToDeleted;
        SolrCore solrCore = this.getCommonSolrCore$chat_service();
        SolrIndexService solrIndexService = this;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SolrInputDocument)p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv;
        solrIndexService.deleteSolrDocuments(solrCore, (List)collection);
        $this$map$iv = chats2.values();
        solrCore = this.getCommonSolrCore$chat_service();
        solrIndexService = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void chat;
            p0 = (Chat)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$toCommonCoreSolrDocument((Companion)Companion, (Chat)chat, (List)((List)chatPartners.get(chat.getId())), (List)chatParticipants.getOrDefault(chat.getId(), CollectionsKt.emptyList())));
        }
        collection = (List)destination$iv$iv;
        solrIndexService.addSolrDocuments(solrCore, collection);
    }

    /*
     * WARNING - void declaration
     */
    private void indexChatCore(List<? extends SearchId> searchIds) {
        Collection<String> collection;
        Collection<String> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection3;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        if (searchIds.isEmpty()) {
            return;
        }
        Iterable $this$filterIsInstanceToSet$iv = searchIds;
        boolean $i$f$filterIsInstanceToSet = false;
        Iterable iterable = $this$filterIsInstanceToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ChatId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set chatIds2 = (Set)destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv2 = searchIds;
        boolean $i$f$filterIsInstanceToSet2 = false;
        destination$iv$iv = $this$filterIsInstanceToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ChatMessageId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set chatMessageIds = (Set)destination$iv$iv2;
        Map chats2 = this.chatService.findByIds(chatIds2);
        Map chatParticipants = this.chatParticipantService.findByChatIds((Iterable)chats2.keySet());
        Map chatPartners = this.loadOneOnOneChatPartners(chats2, chatParticipants);
        Set chatIdsToDeleted = SetsKt.minus((Set)chatIds2, (Iterable)chats2.keySet());
        Map userMessages = this.loadUserMessages(chatMessageIds);
        Set messageIdsToDeleted = SetsKt.minus((Set)chatMessageIds, (Iterable)userMessages.keySet());
        Iterable iterable2 = chats2.values();
        boolean $i$f$map22 = false;
        void var13_20 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void chat;
            Chat chat2 = (Chat)item$iv$iv;
            collection3 = destination$iv$iv3;
            boolean bl = false;
            collection3.add(Companion.access$toChatCoreSolrDocument((Companion)Companion, (Chat)chat, (List)((List)chatPartners.get(chat.getId())), (List)chatParticipants.getOrDefault(chat.getId(), CollectionsKt.emptyList())));
        }
        List chatSolrInputDocs = (List)destination$iv$iv3;
        List messageSolrInputDocs = this.toSolrInputDocuments((Iterable)userMessages.values());
        Iterable $i$f$map22 = chatIdsToDeleted;
        SolrCore solrCore = this.getChatSolrCore$chat_service();
        collection3 = this;
        boolean $i$f$map = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId bl = (ChatId)item$iv$iv;
            collection2 = destination$iv$iv4;
            boolean bl2 = false;
            collection2.add(p0.toCanonicalId());
        }
        collection2 = (List)destination$iv$iv4;
        $this$map$iv = messageIdsToDeleted;
        collection2 = collection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatMessageId p0 = (ChatMessageId)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv4;
        super.deleteSolrDocuments(solrCore, CollectionsKt.plus(collection2, (Iterable)collection));
        this.deleteByChatIds(this.getChatSolrCore$chat_service(), chatIdsToDeleted);
        this.addSolrDocuments(this.getChatSolrCore$chat_service(), CollectionsKt.plus((Collection)chatSolrInputDocs, (Iterable)messageSolrInputDocs));
        LOG.debug("Index Summary: \nIndexed documents: " + (chatSolrInputDocs.size() + messageSolrInputDocs.size()) + "\nChats documents: " + chatSolrInputDocs.size() + "\nmessages documents: " + messageSolrInputDocs.size() + "\ndeleted documents: " + chatIdsToDeleted.size());
    }

    /*
     * WARNING - void declaration
     */
    private List<SolrInputDocument> toSolrInputDocuments(Iterable<UserMessage> userMessages) {
        void $this$mapTo$iv$iv;
        Iterable<UserMessage> $this$map$iv = userMessages;
        boolean $i$f$map = false;
        Iterable<UserMessage> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void userMessage;
            UserMessage userMessage2 = (UserMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$toChatCoreSolrDocument((Companion)Companion, (UserMessage)userMessage));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatMessageId, UserMessage> loadUserMessages(Set<ChatMessageId> chatMessageIds) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        Map $this$mapValuesNotNull$iv = this.chatMessageService.findByIds(chatMessageIds);
        boolean $i$f$mapValuesNotNull = false;
        Iterable iterable = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry$iv = (Map.Entry)element$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = entry$iv;
            boolean bl3 = false;
            ChatMessage message = (ChatMessage)entry.getValue();
            if ((message instanceof UserMessage ? (UserMessage)message : null) != null) {
                UserMessage it$iv;
                it$iv = it$iv;
                boolean bl4 = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv2;
            Pair it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatId, Chat> loadChats(Set<ChatId> chatIds2) {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.chatService.findByIds(chatIds2);
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Chat chat = (Chat)entry.getValue();
            if (!(!(chat instanceof OneOnOneChat) || chat.getLastMessageId() != null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatId, List<Profile>> loadOneOnOneChatPartners(Map<ChatId, ? extends Chat> chats2, Map<ChatId, ? extends List<ChatParticipant>> chatParticipants) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void $this$filterIsInstanceToSet$iv$iv;
        Iterable p0$iv;
        void $this$mapTo$iv$iv$iv;
        void $this$filterParticipantIds$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = chats2.values();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof OneOnOneChat)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet22 = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Chat chat = (Chat)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.getId());
        }
        Set oneOnOneChatIds = (Set)destination$iv$iv;
        ChatParticipant.Companion $i$f$mapToSet22 = ChatParticipant.Companion;
        $this$mapTo$iv$iv = oneOnOneChatIds;
        boolean $i$f$mapNotNull = false;
        void $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ChatId chatId = $this$forEach$iv$iv$iv.iterator();
        while (chatId.hasNext()) {
            List<ChatParticipant> it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = chatId.next();
            boolean bl = false;
            ChatId p0 = (ChatId)element$iv$iv;
            boolean bl2 = false;
            if (chatParticipants.get(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        boolean $i$f$filterParticipantIds = false;
        Iterable $this$map$iv$iv = $this$filterParticipantIds$iv;
        boolean $i$f$map = false;
        void $i$f$mapNotNullTo22 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            element$iv$iv = (ChatParticipant)item$iv$iv$iv;
            Collection bl = destination$iv$iv$iv;
            boolean bl4 = false;
            bl.add(p0$iv.getParticipantId());
        }
        $this$map$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$filterIsInstanceToSet = false;
        $this$mapTo$iv$iv$iv = $this$filterIsInstanceToSet$iv$iv;
        destination$iv$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv$iv));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Set oneOnOneChatPartnerIds = (Set)destination$iv$iv$iv;
        Map profilesById = this.profileService.findByIds(oneOnOneChatPartnerIds);
        Iterable $this$associateWith$iv = oneOnOneChatIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv3 : $this$associateWithTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            void chatId2;
            chatId = (ChatId)element$iv$iv3;
            Object e = element$iv$iv3;
            object = result$iv;
            boolean bl = false;
            p0$iv = chatParticipants.getOrDefault(chatId2, CollectionsKt.emptyList());
            boolean $i$f$mapNotNull2 = false;
            void bl4 = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Profile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv4 = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                ChatParticipant participant = (ChatParticipant)element$iv$iv4;
                boolean bl6 = false;
                if ((Profile)profilesById.get(participant.getParticipantId()) == null) continue;
                boolean bl7 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            object.put(e, list);
        }
        return result$iv;
    }

    private void addSolrDocuments(SolrCore $this$addSolrDocuments, List<? extends SolrInputDocument> documents) {
        if (documents.isEmpty()) {
            return;
        }
        try {
            $this$addSolrDocuments.getClient().add((Collection)documents);
            $this$addSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(documents.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch adding of " + documents.size() + " documents for solr core " + $this$addSolrDocuments.getCoreName() + " failed. Try to add documents individually.", (Throwable)e);
            this.addSolrDocumentsIndividually($this$addSolrDocuments, documents);
        }
    }

    private void addSolrDocumentsIndividually(SolrCore $this$addSolrDocumentsIndividually, List<? extends SolrInputDocument> documents) {
        Iterable $this$forEach$iv = documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument document = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                $this$addSolrDocumentsIndividually.getClient().add(document);
                $this$addSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)document.get((Object)"id");
                LOG.error("Failed to index solr document for " + (solrInputField != null ? solrInputField.getValue() : null) + " in solr core " + $this$addSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$addSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    private void deleteSolrDocuments(SolrCore $this$deleteSolrDocuments, List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            $this$deleteSolrDocuments.getClient().deleteById(ids);
            $this$deleteSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(ids.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch deletion of " + ids.size() + " documents for solr core " + $this$deleteSolrDocuments.getCoreName() + " failed. Try to delete documents individually.", (Throwable)e);
            this.deleteSolrDocumentsIndividually($this$deleteSolrDocuments, ids);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteByChatIds(SolrCore $this$deleteByChatIds, Set<ChatId> chatIds2) {
        void $this$mapTo$iv$iv;
        if (chatIds2.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = chatIds2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)20);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List chunk = (List)element$iv;
            boolean bl = false;
            try {
                LOG.info("Delete from " + $this$deleteByChatIds.getCoreName() + " core by chat_id = " + chunk);
                $this$deleteByChatIds.getClient().deleteByQuery(CollectionsKt.joinToString$default((Iterable)chunk, (CharSequence)" OR ", null, null, (int)0, null, (Function1)((Function1)deleteByChatIds.2.1.INSTANCE), (int)30, null));
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.warn("Failed to delete by chatIds = " + chunk + " for for solr core " + $this$deleteByChatIds.getCoreName() + ". Deletion will be skipped!", (Throwable)e);
            }
        }
    }

    private void deleteSolrDocumentsIndividually(SolrCore $this$deleteSolrDocumentsIndividually, List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            try {
                $this$deleteSolrDocumentsIndividually.getClient().deleteById(id);
                $this$deleteSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.error("Failed to delete solr document " + id + " from solr core " + $this$deleteSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$deleteSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    private boolean isReindexingChatCore() {
        Thread thread = this.chatCoreReindexThread;
        return thread != null ? thread.isAlive() : false;
    }

    private ChatId getChatId(ConsumerRecord<String, String> $this$getChatId) {
        ChatId chatId;
        try {
            Object object = $this$getChatId.key();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key()");
            chatId = ChatId.Companion.fromCanonicalId((String)object);
        }
        catch (Throwable e) {
            LOG.warn("Failed to parse record[key=" + $this$getChatId.key() + ", value=" + $this$getChatId.value() + "] to chat id. We will skip this record.", e);
            chatId = null;
        }
        return chatId;
    }

    /*
     * WARNING - void declaration
     */
    private List<SearchId> toSearchIds(ConsumerRecord<String, String> $this$toSearchIds) {
        Object object;
        try {
            void $this$readValue$iv;
            object = (ObjectMapper)KafkaObjectMapper.INSTANCE;
            Object object2 = $this$toSearchIds.value();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value()");
            String content$iv = (String)object2;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = (List)$this$readValue$iv.readValue(content$iv, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable e) {
            LOG.warn("Failed to parse record[key=" + $this$toSearchIds.key() + ", value=" + $this$toSearchIds.value() + "] to search id. We will skip this record.", e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final void reindexChatsInCommonCore$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ CommonCoreSearchUpdateIndexProducer access$getCommonCoreSearchUpdateIndexProducer$p(SolrIndexService $this) {
        return $this.commonCoreSearchUpdateIndexProducer;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ SolrClient access$getChatCoreLeaderSolrClient$p(SolrIndexService $this) {
        return $this.chatCoreLeaderSolrClient;
    }

    public static final /* synthetic */ ChatCoreSearchUpdateIndexProducer access$getChatCoreSearchUpdateIndexProducer$p(SolrIndexService $this) {
        return $this.chatCoreSearchUpdateIndexProducer;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

