/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.persistence.ChatMessageSpecifications;
import de.justsoftware.chat.persistence.model.DbChatMessage;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J \u0010\u000f\u001a\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\u000bH\u0002J\u0016\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\u000bH\u0002J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\u000bH\u0002\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageSpecifications;", "", "()V", "attachmentMimeTypePath", "Ljakarta/persistence/criteria/Path;", "", "kotlin.jvm.PlatformType", "root", "Ljakarta/persistence/criteria/Root;", "Lde/justsoftware/chat/persistence/model/DbChatMessage;", "witCreatedAtGreaterThan", "Lorg/springframework/data/jpa/domain/Specification;", "createdAt", "Ljava/time/Instant;", "withAnyAttachment", "withAttachments", "filter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "withChatId", "chatId", "Ljava/util/UUID;", "withChatIdIn", "chatIds", "", "withCreatedAtLessThan", "withImageAttachment", "withMediaAttachment", "withUpdatedAtGreaterThan", "updatedAt", "withVideoAttachment", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageSpecifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageSpecifications.kt\nde/justsoftware/chat/persistence/ChatMessageSpecifications\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1#2:101\n1855#3,2:102\n*S KotlinDebug\n*F\n+ 1 ChatMessageSpecifications.kt\nde/justsoftware/chat/persistence/ChatMessageSpecifications\n*L\n92#1:102,2\n*E\n"})
public final class ChatMessageSpecifications {
    @NotNull
    public static final ChatMessageSpecifications INSTANCE = new ChatMessageSpecifications();

    private ChatMessageSpecifications() {
    }

    @NotNull
    public final Specification<DbChatMessage> withChatId(@NotNull UUID chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withChatId$lambda$0(chatId, arg_0, arg_1, arg_2);
    }

    @NotNull
    public final Specification<DbChatMessage> withChatIdIn(@NotNull Collection<UUID> chatIds2) {
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withChatIdIn$lambda$1(chatIds2, arg_0, arg_1, arg_2);
    }

    @Nullable
    public final Specification<DbChatMessage> withCreatedAtLessThan(@Nullable Instant createdAt) {
        return createdAt != null ? (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withCreatedAtLessThan$lambda$2(createdAt, arg_0, arg_1, arg_2) : null;
    }

    @Nullable
    public final Specification<DbChatMessage> witCreatedAtGreaterThan(@Nullable Instant createdAt) {
        return createdAt != null ? (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.witCreatedAtGreaterThan$lambda$3(createdAt, arg_0, arg_1, arg_2) : null;
    }

    @Nullable
    public final Specification<DbChatMessage> withUpdatedAtGreaterThan(@Nullable Instant updatedAt) {
        return updatedAt != null ? (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withUpdatedAtGreaterThan$lambda$4(updatedAt, arg_0, arg_1, arg_2) : null;
    }

    @Nullable
    public final Specification<DbChatMessage> withAttachments(@Nullable AttachmentFilter filter) {
        AttachmentFilter attachmentFilter = filter;
        return switch (attachmentFilter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[attachmentFilter.ordinal()]) {
            case 1 -> this.withImageAttachment();
            case 2 -> this.withVideoAttachment();
            case 3 -> this.withMediaAttachment();
            case 4 -> Specification.not((Specification)this.withMediaAttachment());
            case 5 -> this.withAnyAttachment();
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Specification<DbChatMessage> withAnyAttachment() {
        return ChatMessageSpecifications::withAnyAttachment$lambda$5;
    }

    private final Specification<DbChatMessage> withImageAttachment() {
        return ChatMessageSpecifications::withImageAttachment$lambda$6;
    }

    private final Specification<DbChatMessage> withVideoAttachment() {
        return ChatMessageSpecifications::withVideoAttachment$lambda$7;
    }

    private final Specification<DbChatMessage> withMediaAttachment() {
        return ChatMessageSpecifications::withMediaAttachment$lambda$9;
    }

    private final Path<String> attachmentMimeTypePath(Root<DbChatMessage> root) {
        return root.join("attachments").get("mimeType");
    }

    private static final Predicate withChatId$lambda$0(UUID $chatId, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        return criteriaBuilder.equal((Expression)root.get("chatId"), (Object)$chatId);
    }

    private static final Predicate withChatIdIn$lambda$1(Collection $chatIds, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullParameter((Object)$chatIds, (String)"$chatIds");
        return root.get("chatId").in($chatIds);
    }

    private static final Predicate withCreatedAtLessThan$lambda$2(Instant $createdAt, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.lessThan((Expression)root.get("createdAt"), (Comparable)$createdAt);
    }

    private static final Predicate witCreatedAtGreaterThan$lambda$3(Instant $createdAt, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThan((Expression)root.get("createdAt"), (Comparable)$createdAt);
    }

    private static final Predicate withUpdatedAtGreaterThan$lambda$4(Instant $updatedAt, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThan((Expression)root.get("updatedAt"), (Comparable)$updatedAt);
    }

    private static final Predicate withAnyAttachment$lambda$5(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.isNotEmpty((Expression)root.get("attachments"));
    }

    private static final Predicate withImageAttachment$lambda$6(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        return INSTANCE.attachmentMimeTypePath(root).in((Collection)ChatMessageService.Companion.getIMAGE_FORMATS());
    }

    private static final Predicate withVideoAttachment$lambda$7(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        Path mimeTypePath = INSTANCE.attachmentMimeTypePath(root);
        return criteriaBuilder.like((Expression)mimeTypePath, "video/%");
    }

    private static final Predicate withMediaAttachment$lambda$9(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        CriteriaBuilder.In in;
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        Path mimeTypePath = INSTANCE.attachmentMimeTypePath(root);
        CriteriaBuilder.In $this$withMediaAttachment_u24lambda_u249_u24lambda_u248 = in = criteriaBuilder.in((Expression)mimeTypePath);
        boolean bl = false;
        Iterable $this$forEach$iv = ChatMessageService.Companion.getIMAGE_FORMATS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl2 = false;
            $this$withMediaAttachment_u24lambda_u249_u24lambda_u248.value((Object)p0);
        }
        CriteriaBuilder.In imagePredicate = in;
        Predicate videoPredicate = criteriaBuilder.like((Expression)mimeTypePath, "video/%");
        Predicate[] predicateArray = new Predicate[]{imagePredicate, videoPredicate};
        return criteriaBuilder.or(predicateArray);
    }
}

