/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka.search;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageDeletedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.ChatsDeletedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.kafka.KafkaObjectMapper;
import de.justsoftware.chat.kafka.search.ChatCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.SearchId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 /2\u00020\u0001:\u0001/B1\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0011\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0011\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0011\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0011\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0011\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0011\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020!H\u0011\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0012J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0012J\b\u0010)\u001a\u00020\rH\u0017J\u0018\u0010*\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0012J\u001e\u0010*\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.H\u0012R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatMessageService;)V", "handleChatCreated", "", "evt", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "handleChatCreated$chat_service", "handleChatMessageCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageCreatedEvent;", "handleChatMessageCreatedEvent$chat_service", "handleChatMessageDeletedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageDeletedEvent;", "handleChatMessageDeletedEvent$chat_service", "handleChatParticipantsChanged", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "handleChatParticipantsChanged$chat_service", "handleChatUpdated", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "handleChatUpdated$chat_service", "handleChatsDeleted", "Lde/justsoftware/chat/business/model/event/ChatsDeletedEvent;", "handleChatsDeleted$chat_service", "handleProfileUpdated", "Lde/justsoftware/chat/business/model/event/ProfileUpdatedEvent;", "handleProfileUpdated$chat_service", "indexChat", "chatId", "Lde/justsoftware/chat/model/ChatId;", "indexMessage", "message", "Lde/justsoftware/chat/business/model/ChatMessage;", "reindexChatCore", "send", "searchId", "Lde/justsoftware/chat/model/SearchId;", "searchIds", "", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatCoreSearchUpdateIndexProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCoreSearchUpdateIndexProducer.kt\nde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,116:1\n1855#2,2:117\n1855#2,2:119\n9#3:121\n8#3,3:122\n*S KotlinDebug\n*F\n+ 1 ChatCoreSearchUpdateIndexProducer.kt\nde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer\n*L\n75#1:117,2\n82#1:119,2\n113#1:121\n113#1:122,3\n*E\n"})
public class ChatCoreSearchUpdateIndexProducer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    public static final String TOPIC = "just.chat-service.search.chat.updateIndex";
    @NotNull
    private static final Logger LOG;

    public ChatCoreSearchUpdateIndexProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatMessageService chatMessageService) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        this.kafkaProducer = kafkaProducer;
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.chatMessageService = chatMessageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public void reindexChatCore() {
        long start = System.currentTimeMillis();
        LOG.info("Start to fill the index kafka topic with chatIds...");
        Ref.IntRef chatCount = new Ref.IntRef();
        AutoCloseable autoCloseable = this.chatService.streamAllIds();
        Throwable throwable = null;
        try {
            Stream chatIds2 = (Stream)autoCloseable;
            boolean bl = false;
            chatIds2.peek(arg_0 -> ChatCoreSearchUpdateIndexProducer.reindexChatCore$lambda$3$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).forEach(arg_0 -> ChatCoreSearchUpdateIndexProducer.reindexChatCore$lambda$3$lambda$1((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            LOG.info("Filling chatIds into index kafka topic finished. Start to fill the index kafka topic with chatMessageIds...");
            Ref.IntRef messageCount = new Ref.IntRef();
            CollectionUtilsKt.chunked((Stream)this.chatMessageService.streamAllUserMessageIds(), (int)1000).forEach(arg_0 -> ChatCoreSearchUpdateIndexProducer.reindexChatCore$lambda$3$lambda$2((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            LOG.info("Filling chatMessageIds into index kafka topic finished.\n" + chatCount.element + " chatIds was written into index kafka topic.\n" + messageCount.element + " chatMessageIds was written into index kafka topic.\nFilling kafka topic took " + (System.currentTimeMillis() - start) + " ms.");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @EventListener
    public void handleChatCreated$chat_service(@NotNull ChatCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getChat() instanceof MultiUserChat) {
            this.indexChat(evt.getChatId());
        }
    }

    @EventListener
    public void handleChatUpdated$chat_service(@NotNull ChatUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.indexChat(evt.getChatId());
    }

    @EventListener
    public void handleChatsDeleted$chat_service(@NotNull ChatsDeletedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = evt.getChatIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean bl = false;
            this.indexChat(p0);
        }
    }

    @EventListener
    public void handleChatParticipantsChanged$chat_service(@NotNull ChatParticipantsChangedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.indexChat(evt.getChatId());
    }

    @EventListener
    public void handleProfileUpdated$chat_service(@NotNull ProfileUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = this.chatParticipantService.findOneOnOneChatIdsByProfileId(evt.getProfileId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean bl = false;
            this.indexChat(p0);
        }
    }

    @EventListener
    public void handleChatMessageCreatedEvent$chat_service(@NotNull ChatMessageCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getChatMessage() instanceof UserMessage) {
            this.indexMessage(evt.getChatMessage());
        }
    }

    @EventListener
    public void handleChatMessageDeletedEvent$chat_service(@NotNull ChatMessageDeletedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChat().getId(), (SearchId)evt.getChatMessageId());
    }

    private void indexChat(ChatId chatId) {
        this.send(chatId, (SearchId)chatId);
    }

    private void indexMessage(ChatMessage message) {
        this.send(message.getChatId(), (SearchId)message.getId());
    }

    private void send(ChatId chatId, SearchId searchId) {
        this.send(chatId, SetsKt.setOf((Object)searchId));
    }

    private void send(ChatId chatId, Set<? extends SearchId> searchIds) {
        this.kafkaProducer.send(new ProducerRecord(TOPIC, (Object)chatId.toCanonicalId(), (Object)KafkaObjectMapper.INSTANCE.writeValueAsString(searchIds)));
    }

    private static final void reindexChatCore$lambda$3$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void reindexChatCore$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void reindexChatCore$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$indexChat(ChatCoreSearchUpdateIndexProducer $this, ChatId chatId) {
        $this.indexChat(chatId);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$send(ChatCoreSearchUpdateIndexProducer $this, ChatId chatId, Set searchIds) {
        $this.send(chatId, searchIds);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

