/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"Lde/justsoftware/chat/config/ClockWithMillisecondPrecision;", "Ljava/time/Clock;", "clock", "(Ljava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "getZone", "Ljava/time/ZoneId;", "instant", "Ljava/time/Instant;", "withZone", "zone", "chat-service"})
public final class ClockWithMillisecondPrecision
extends Clock {
    @NotNull
    private final Clock clock;

    public ClockWithMillisecondPrecision(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
    }

    public /* synthetic */ ClockWithMillisecondPrecision(Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        this(clock);
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @Override
    @NotNull
    public Instant instant() {
        Instant instant = this.clock.instant().truncatedTo(ChronoUnit.MILLIS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant().truncatedTo(ChronoUnit.MILLIS)");
        return instant;
    }

    @Override
    @NotNull
    public ZoneId getZone() {
        ZoneId zoneId = this.clock.getZone();
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"clock.zone");
        return zoneId;
    }

    @Override
    @NotNull
    public Clock withZone(@NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        Clock clock = this.clock.withZone(zone);
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"clock.withZone(zone)");
        return (Clock)new ClockWithMillisecondPrecision(clock);
    }

    public ClockWithMillisecondPrecision() {
        this(null, 1, null);
    }
}

