/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.ControlMessageDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.UserMessageDto;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.XmppRestApiService;
import de.justsoftware.chat.business.XmppService;
import de.justsoftware.chat.business.XmppService$onChatParticipantsChangedEvent$lambda$7$;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.ControlMessage;
import de.justsoftware.chat.business.model.DeletedMessage;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.SystemMessage;
import de.justsoftware.chat.business.model.UserGroupMember;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.event.ChatMarkedAsReadEvent;
import de.justsoftware.chat.business.model.event.ChatMarkedAsUnreadEvent;
import de.justsoftware.chat.business.model.event.ChatMessageCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageDeletedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatSettingsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.UserGroupDeletedEvent;
import de.justsoftware.chat.business.model.event.UserGroupMembersAddedEvent;
import de.justsoftware.chat.business.model.event.UserGroupMembersRemovedEvent;
import de.justsoftware.chat.business.model.xmpp.CreateNodeStanza;
import de.justsoftware.chat.business.model.xmpp.DeleteNodeStanza;
import de.justsoftware.chat.business.model.xmpp.PubSubOperation;
import de.justsoftware.chat.business.model.xmpp.XmppStanza;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.kafka.PubSubOperationKafkaProducer;
import de.justsoftware.chat.kafka.model.KafkaPubSubOperation;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.model.Id;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 U2\u00020\u0001:\u0001UB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012J\u001e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0012J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0017J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0017J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010(\u001a\u00020+H\u0017J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0017J\u0010\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u000201H\u0017J\u0010\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u000204H\u0017J#\u00105\u001a\u00020\u00102\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0006\u0012\u0004\u0018\u00010907H\u0011\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u00020\u00102\u0006\u0010(\u001a\u00020<H\u0017J\u0010\u0010=\u001a\u00020\u00102\u0006\u0010(\u001a\u00020>H\u0017J\u0010\u0010?\u001a\u00020\u00102\u0006\u0010(\u001a\u00020@H\u0017J&\u0010A\u001a\u00020\u00102\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u001a2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0012J\u001a\u0010H\u001a\u00020\u00102\u0006\u0010I\u001a\u0002082\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0012J\u0018\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020L2\u0006\u0010I\u001a\u000208H\u0012J\u001e\u0010M\u001a\u00020\u00102\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010F\u001a\u00020OH\u0012J\u001e\u0010P\u001a\u00020\u00102\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010F\u001a\u00020GH\u0012J\f\u0010Q\u001a\u00020R*\u00020SH\u0012J\f\u0010Q\u001a\u00020R*\u00020TH\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lde/justsoftware/chat/business/XmppService;", "", "pubSubOperationKafkaProducer", "Lde/justsoftware/chat/kafka/PubSubOperationKafkaProducer;", "xmppRestApiService", "Lde/justsoftware/chat/business/XmppRestApiService;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "(Lde/justsoftware/chat/kafka/PubSubOperationKafkaProducer;Lde/justsoftware/chat/business/XmppRestApiService;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ProfileService;)V", "clearAndSyncChatNodes", "", "enqueueCreateNodeTask", "nodeId", "Lde/justsoftware/chat/model/Id;", "enqueueDeleteNodeTask", "enqueuePublishMessage", "chatMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "enqueueSubscribeTask", "subscriber", "", "Lde/justsoftware/chat/model/ProfileId;", "enqueueUnsubscribeTask", "getUserMessageDto", "Lde/justsoftware/chat/application/model/UserMessageDto;", "chatMessage", "Lde/justsoftware/chat/business/model/UserMessage;", "onChatMarkedAsRead", "chatMarkedAsReadEvent", "Lde/justsoftware/chat/business/model/event/ChatMarkedAsReadEvent;", "onChatMarkedAsUnread", "chatMarkedAsUnreadEvent", "Lde/justsoftware/chat/business/model/event/ChatMarkedAsUnreadEvent;", "onChatMessageCreated", "event", "Lde/justsoftware/chat/business/model/event/ChatMessageCreatedEvent;", "onChatMessageDeleted", "Lde/justsoftware/chat/business/model/event/ChatMessageDeletedEvent;", "onChatParticipantsChangedEvent", "chatParticipantsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "onChatSettingsChanged", "chatSettingsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatSettingsChangedEvent;", "onChatUpdated", "chatUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "onPubSubOperation", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "Lde/justsoftware/chat/kafka/model/KafkaPubSubOperation;", "onPubSubOperation$chat_service", "onUserGroupDeleted", "Lde/justsoftware/chat/business/model/event/UserGroupDeletedEvent;", "onUserGroupMembersAdded", "Lde/justsoftware/chat/business/model/event/UserGroupMembersAddedEvent;", "onUserGroupMembersRemoved", "Lde/justsoftware/chat/business/model/event/UserGroupMembersRemovedEvent;", "publishControlMessageToUserGroupsAndChat", "userGroupIds", "Lde/justsoftware/chat/model/UserGroupId;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "message", "Lde/justsoftware/chat/business/model/ControlMessage;", "publishGroupChatMessage", "nodeName", "publishStanza", "pubSubOperation", "Lde/justsoftware/chat/business/model/xmpp/PubSubOperation;", "sendChatMessage", "recipients", "Lde/justsoftware/chat/business/model/ChatMessage;", "sendControlMessageToDirectParticipants", "toControlMessage", "Lde/justsoftware/chat/business/model/ControlMessage$LoadMessage;", "Lde/justsoftware/chat/business/model/DeletedMessage;", "Lde/justsoftware/chat/business/model/SystemMessage;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nXmppService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmppService.kt\nde/justsoftware/chat/business/XmppService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 4 OptionalUtils.kt\nde/justsoftware/chat/util/OptionalUtilsKt\n+ 5 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,417:1\n1549#2:418\n1620#2,3:419\n809#2,2:423\n809#2,2:426\n809#2,2:429\n809#2,2:433\n809#2,2:436\n809#2,2:439\n1549#2:441\n1620#2,3:442\n809#2,2:446\n1855#2,2:448\n22#3:422\n22#3:425\n22#3:428\n22#3:432\n22#3:435\n22#3:438\n22#3:445\n5#4:431\n9#5:450\n8#5,3:451\n*S KotlinDebug\n*F\n+ 1 XmppService.kt\nde/justsoftware/chat/business/XmppService\n*L\n105#1:418\n105#1:419,3\n107#1:423,2\n108#1:426,2\n148#1:429,2\n166#1:433,2\n175#1:436,2\n176#1:439,2\n224#1:441\n224#1:442,3\n225#1:446,2\n255#1:448,2\n107#1:422\n108#1:425\n148#1:428\n166#1:432\n175#1:435\n176#1:438\n225#1:445\n154#1:431\n414#1:450\n414#1:451,3\n*E\n"})
public class XmppService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final PubSubOperationKafkaProducer pubSubOperationKafkaProducer;
    @NotNull
    private final XmppRestApiService xmppRestApiService;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ProfileService profileService;
    public static final int SUBSCRIBER_PARTITION_SIZE = 200;
    @NotNull
    private static final Logger LOG;

    public XmppService(@NotNull PubSubOperationKafkaProducer pubSubOperationKafkaProducer, @NotNull XmppRestApiService xmppRestApiService, @NotNull ChatService chatService, @NotNull ChatMessageService chatMessageService, @NotNull ChatParticipantService chatParticipantService, @NotNull ProfileService profileService) {
        Intrinsics.checkNotNullParameter((Object)pubSubOperationKafkaProducer, (String)"pubSubOperationKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)xmppRestApiService, (String)"xmppRestApiService");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        this.pubSubOperationKafkaProducer = pubSubOperationKafkaProducer;
        this.xmppRestApiService = xmppRestApiService;
        this.chatService = chatService;
        this.chatMessageService = chatMessageService;
        this.chatParticipantService = chatParticipantService;
        this.profileService = profileService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void clearAndSyncChatNodes() {
        AutoCloseable autoCloseable = this.chatService.findIdsByType(ChatType.MULTI_USER_CHAT);
        Throwable throwable = null;
        try {
            Stream chatIds2 = (Stream)autoCloseable;
            boolean bl = false;
            Ref.IntRef chatCount = new Ref.IntRef();
            CollectionUtilsKt.chunked((Stream)chatIds2, (int)1000).forEach(arg_0 -> XmppService.clearAndSyncChatNodes$lambda$1$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @EventListener
    public void onChatMessageCreated(@NotNull ChatMessageCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.chatService.findById(event.getChatMessage().getChatId()).ifPresent(arg_0 -> XmppService.onChatMessageCreated$lambda$2((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void onChatMessageDeleted(@NotNull ChatMessageDeletedEvent event) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ChatId chatId = event.getChat().getId();
        Iterable iterable = this.chatParticipantService.findByChatId(chatId);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getParticipantId());
        }
        List participants = (List)destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv = participants;
        boolean $i$f$filterIsInstanceToSet = false;
        destination$iv$iv = $this$filterIsInstanceToSet$iv;
        Iterable destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set groupIds = (Set)destination$iv$iv2;
        Iterable $this$filterIsInstanceToSet$iv2 = participants;
        boolean $i$f$filterIsInstanceToSet2 = false;
        destination$iv$iv2 = $this$filterIsInstanceToSet$iv2;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv3;
        ControlMessage.LoadMessage controlMessage = new ControlMessage.LoadMessage(chatId, event.getChatMessageId());
        Chat chat = event.getChat();
        if (chat instanceof MultiUserChat) {
            this.publishControlMessageToUserGroupsAndChat(groupIds, chatId, (ControlMessage)controlMessage);
        } else if (chat instanceof OneOnOneChat) {
            this.sendControlMessageToDirectParticipants(profileIds, (ControlMessage)controlMessage);
        }
    }

    @EventListener
    public void onUserGroupDeleted(@NotNull UserGroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.enqueueDeleteNodeTask((Id)event.getUserGroupId());
    }

    @EventListener
    public void onUserGroupMembersAdded(@NotNull UserGroupMembersAddedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UserGroupMember.Companion.toProfileIdsByGroupId((Collection)event.getUserGroupMembers()).forEach((arg_0, arg_1) -> XmppService.onUserGroupMembersAdded$lambda$4((Function2)new /* Unavailable Anonymous Inner Class!! */, arg_0, arg_1));
    }

    @EventListener
    public void onUserGroupMembersRemoved(@NotNull UserGroupMembersRemovedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UserGroupMember.Companion.toProfileIdsByGroupId((Collection)event.getUserGroupMembers()).forEach((arg_0, arg_1) -> XmppService.onUserGroupMembersRemoved$lambda$5((Function2)new /* Unavailable Anonymous Inner Class!! */, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void onChatParticipantsChangedEvent(@NotNull ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        Iterable $this$filterIsInstance$iv;
        Set set;
        void $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$filterIsInstanceTo;
        Iterable<Object> destination$iv$iv;
        Optional $this$filterIsInstanceToSet$iv;
        boolean $i$f$filterIsInstanceToSet;
        XmppService xmppService;
        Id id;
        Intrinsics.checkNotNullParameter((Object)chatParticipantsChangedEvent, (String)"chatParticipantsChangedEvent");
        ChatParticipantsChangedEvent $this$onChatParticipantsChangedEvent_u24lambda_u247 = chatParticipantsChangedEvent;
        boolean bl = false;
        if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u247.getParticipantsAdded()).isEmpty() || !((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u247.getEffectiveProfileIdsAdded()).isEmpty()) {
            Iterable iterable = $this$onChatParticipantsChangedEvent_u24lambda_u247.getParticipantsAdded();
            id = (Id)$this$onChatParticipantsChangedEvent_u24lambda_u247.getChatId();
            xmppService = this;
            $i$f$filterIsInstanceToSet = false;
            void var8_9 = $this$filterIsInstanceToSet$iv;
            destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)((Object)$this$filterIsInstanceToSet$iv)));
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProfileId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set = (Set)destination$iv$iv;
            xmppService.enqueueSubscribeTask(id, set);
            $this$filterIsInstanceToSet$iv = this.chatService.findById($this$onChatParticipantsChangedEvent_u24lambda_u247.getChatId());
            boolean $i$f$filterIsInstance = false;
            Optional optional = ((Optional)((Object)$this$filterIsInstance$iv)).map((Function)onChatParticipantsChangedEvent$lambda$7$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"map { it as? R }");
            optional.ifPresent(arg_0 -> XmppService.onChatParticipantsChangedEvent$lambda$7$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        }
        if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u247.getParticipantsRemoved()).isEmpty() || !((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u247.getEffectiveProfileIdsRemoved()).isEmpty()) {
            $this$filterIsInstance$iv = $this$onChatParticipantsChangedEvent_u24lambda_u247.getParticipantsRemoved();
            id = (Id)$this$onChatParticipantsChangedEvent_u24lambda_u247.getChatId();
            xmppService = this;
            $i$f$filterIsInstanceToSet = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstanceToSet$iv;
            destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)((Object)$this$filterIsInstanceToSet$iv)));
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProfileId)) continue;
                destination$iv$iv.add((Object)element$iv$iv);
            }
            set = (Set)destination$iv$iv;
            xmppService.enqueueUnsubscribeTask(id, set);
            this.sendControlMessageToDirectParticipants($this$onChatParticipantsChangedEvent_u24lambda_u247.getEffectiveProfileIdsRemoved(), (ControlMessage)new ControlMessage.RemovedFromChat($this$onChatParticipantsChangedEvent_u24lambda_u247.getChatId()));
        }
        if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u247.getParticipantsUpdated()).isEmpty()) {
            void $this$filterIsInstanceTo$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv3;
            Iterable $this$filterIsInstanceToSet$iv2 = $this$onChatParticipantsChangedEvent_u24lambda_u247.getParticipantsUpdated();
            boolean $i$f$filterIsInstanceToSet2 = false;
            destination$iv$iv = $this$filterIsInstanceToSet$iv2;
            Iterable destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv instanceof UserGroupId)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Set groupIds = (Set)destination$iv$iv2;
            Iterable $this$filterIsInstanceToSet$iv3 = $this$onChatParticipantsChangedEvent_u24lambda_u247.getParticipantsUpdated();
            boolean $i$f$filterIsInstanceToSet3 = false;
            destination$iv$iv2 = $this$filterIsInstanceToSet$iv3;
            Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv3));
            boolean $i$f$filterIsInstanceTo3 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof ProfileId)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Set profileIds = (Set)destination$iv$iv3;
            ControlMessage.ParticipantsUpdated message = new ControlMessage.ParticipantsUpdated($this$onChatParticipantsChangedEvent_u24lambda_u247.getChatId());
            if (groupIds.isEmpty()) {
                this.sendControlMessageToDirectParticipants(profileIds, (ControlMessage)message);
            } else {
                this.publishControlMessageToUserGroupsAndChat(groupIds, $this$onChatParticipantsChangedEvent_u24lambda_u247.getChatId(), (ControlMessage)message);
            }
        }
        if ($this$onChatParticipantsChangedEvent_u24lambda_u247.getParticipantsUpdated().isEmpty() && !((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u247.getEffectiveProfileIdsUpdated()).isEmpty()) {
            this.sendControlMessageToDirectParticipants($this$onChatParticipantsChangedEvent_u24lambda_u247.getEffectiveProfileIdsUpdated(), (ControlMessage)new ControlMessage.ParticipantsUpdated($this$onChatParticipantsChangedEvent_u24lambda_u247.getChatId()));
        }
    }

    @EventListener
    public void onChatMarkedAsRead(@NotNull ChatMarkedAsReadEvent chatMarkedAsReadEvent) {
        Intrinsics.checkNotNullParameter((Object)chatMarkedAsReadEvent, (String)"chatMarkedAsReadEvent");
        ChatMarkedAsReadEvent $this$onChatMarkedAsRead_u24lambda_u248 = chatMarkedAsReadEvent;
        boolean bl = false;
        this.sendControlMessageToDirectParticipants(SetsKt.setOf((Object)$this$onChatMarkedAsRead_u24lambda_u248.getProfileId()), (ControlMessage)new ControlMessage.ChatMarkedAsRead($this$onChatMarkedAsRead_u24lambda_u248.getChatId()));
    }

    @EventListener
    public void onChatMarkedAsUnread(@NotNull ChatMarkedAsUnreadEvent chatMarkedAsUnreadEvent) {
        Intrinsics.checkNotNullParameter((Object)chatMarkedAsUnreadEvent, (String)"chatMarkedAsUnreadEvent");
        ChatMarkedAsUnreadEvent $this$onChatMarkedAsUnread_u24lambda_u249 = chatMarkedAsUnreadEvent;
        boolean bl = false;
        this.sendControlMessageToDirectParticipants(SetsKt.setOf((Object)$this$onChatMarkedAsUnread_u24lambda_u249.getProfileId()), (ControlMessage)new ControlMessage.ChatMarkedAsUnread($this$onChatMarkedAsUnread_u24lambda_u249.getChatId()));
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void onChatUpdated(@NotNull ChatUpdatedEvent chatUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatUpdatedEvent, (String)"chatUpdatedEvent");
        ChatUpdatedEvent $this$onChatUpdated_u24lambda_u2411 = chatUpdatedEvent;
        boolean bl = false;
        if ($this$onChatUpdated_u24lambda_u2411.getNewChat() instanceof MultiUserChat && $this$onChatUpdated_u24lambda_u2411.getOldChat() instanceof MultiUserChat && ((MultiUserChat)$this$onChatUpdated_u24lambda_u2411.getNewChat()).getTitle() != ((MultiUserChat)$this$onChatUpdated_u24lambda_u2411.getOldChat()).getTitle()) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstanceToSet$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = this.chatParticipantService.findByChatId($this$onChatUpdated_u24lambda_u2411.getChatId());
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getParticipantId());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstanceToSet = false;
            $this$mapTo$iv$iv = $this$filterIsInstanceToSet$iv;
            destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UserGroupId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set userGroupIds = (Set)destination$iv$iv;
            this.publishControlMessageToUserGroupsAndChat(userGroupIds, $this$onChatUpdated_u24lambda_u2411.getChatId(), (ControlMessage)new ControlMessage.ChatTitleChanged($this$onChatUpdated_u24lambda_u2411.getChatId()));
        }
    }

    @EventListener
    public void onChatSettingsChanged(@NotNull ChatSettingsChangedEvent chatSettingsChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatSettingsChangedEvent, (String)"chatSettingsChangedEvent");
        this.sendControlMessageToDirectParticipants(SetsKt.setOf((Object)chatSettingsChangedEvent.getProfileId()), (ControlMessage)new ControlMessage.ChatSettingsChanged(chatSettingsChangedEvent.getChatId()));
    }

    @KafkaListener(id="pubSubOperationConsumer", containerFactory="pubSubOperationConsumerFactory", topics={"just.chat.pubSub.operations"}, idIsGroup=false)
    public void onPubSubOperation$chat_service(@NotNull ConsumerRecords<String, KafkaPubSubOperation> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            KafkaPubSubOperation kafkaPubSubOperation = (KafkaPubSubOperation)record.value();
            if (kafkaPubSubOperation == null) continue;
            PubSubOperation pubSubOperation = KafkaPubSubOperation.Companion.toPubSubOperation(kafkaPubSubOperation);
            Object object = record.key();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.key()");
            this.publishStanza(pubSubOperation, (String)object);
        }
    }

    private void publishStanza(PubSubOperation pubSubOperation, String nodeName) {
        XmppRestApiService $this$publishStanza_u24lambda_u2413 = this.xmppRestApiService;
        boolean bl = false;
        PubSubOperation pubSubOperation2 = pubSubOperation;
        if (pubSubOperation2 instanceof PubSubOperation.CreateNode) {
            $this$publishStanza_u24lambda_u2413.sendStanza((XmppStanza)new CreateNodeStanza(nodeName, null, 2, null));
        } else if (pubSubOperation2 instanceof PubSubOperation.DeleteNode) {
            $this$publishStanza_u24lambda_u2413.sendStanza((XmppStanza)new DeleteNodeStanza(nodeName, null, 2, null));
        } else if (pubSubOperation2 instanceof PubSubOperation.Subscribe) {
            $this$publishStanza_u24lambda_u2413.sendSubscribeStanza(nodeName, ((PubSubOperation.Subscribe)pubSubOperation).getSubscribers());
        } else if (pubSubOperation2 instanceof PubSubOperation.Unsubscribe) {
            $this$publishStanza_u24lambda_u2413.sendUnsubscribeStanza(nodeName, ((PubSubOperation.Unsubscribe)pubSubOperation).getSubscribers());
        } else if (pubSubOperation2 instanceof PubSubOperation.PublishMessage) {
            this.publishGroupChatMessage(nodeName, ((PubSubOperation.PublishMessage)pubSubOperation).getChatMessageId());
        }
    }

    private void publishGroupChatMessage(String nodeName, ChatMessageId chatMessageId) {
        if (chatMessageId == null) {
            return;
        }
        this.chatMessageService.findById(chatMessageId).ifPresentOrElse(arg_0 -> XmppService.publishGroupChatMessage$lambda$14((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0), () -> XmppService.publishGroupChatMessage$lambda$15(chatMessageId));
    }

    private void sendChatMessage(Set<ProfileId> recipients, ChatMessage message) {
        ChatMessage chatMessage = message;
        if (chatMessage instanceof UserMessage) {
            this.xmppRestApiService.sendChatMessage(recipients, (ChatMessageDto)this.getUserMessageDto((UserMessage)message));
        } else if (chatMessage instanceof SystemMessage) {
            this.sendControlMessageToDirectParticipants(recipients, (ControlMessage)this.toControlMessage((SystemMessage)message));
        } else if (chatMessage instanceof DeletedMessage) {
            this.sendControlMessageToDirectParticipants(recipients, (ControlMessage)this.toControlMessage((DeletedMessage)message));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private UserMessageDto getUserMessageDto(UserMessage chatMessage) {
        ChatMessage citedMessage;
        ChatMessage chatMessage2;
        ChatMessageId chatMessageId = chatMessage.getCitedMessageId();
        if (chatMessageId != null) {
            ChatMessageId it = chatMessageId;
            boolean bl = false;
            chatMessage2 = (ChatMessage)this.chatMessageService.findById(chatMessage.getCitedMessageId()).orElseThrow(XmppService::getUserMessageDto$lambda$17$lambda$16);
        } else {
            chatMessage2 = null;
        }
        ChatMessage chatMessage3 = citedMessage = chatMessage2;
        ChatMessageDto citedMessageDto = chatMessage3 != null ? ChatMessageDto.Companion.toChatMessageDto$default((ChatMessageDto.Companion)ChatMessageDto.Companion, (ChatMessage)chatMessage3, (ProfileDto)ProfileDto.Companion.toProfileDto(this.profileService.getById(citedMessage.getAuthor())), (String)(citedMessage instanceof UserMessage ? ((UserMessage)citedMessage).getMessage() : ""), null, (int)4, null) : null;
        return UserMessageDto.Companion.toUserMessageDto$default((UserMessageDto.Companion)UserMessageDto.Companion, (UserMessage)chatMessage, (ProfileDto)ProfileDto.Companion.toProfileDto(this.profileService.getById(chatMessage.getAuthor())), null, (ChatMessageDto)citedMessageDto, (int)2, null);
    }

    private void sendControlMessageToDirectParticipants(Set<ProfileId> recipients, ControlMessage message) {
        this.xmppRestApiService.sendControlMessage(recipients, ControlMessageDto.Companion.toControlMessageDto(message));
    }

    private void publishControlMessageToUserGroupsAndChat(Set<UserGroupId> userGroupIds, ChatId chatId, ControlMessage message) {
        this.xmppRestApiService.publishControlMessage(chatId.toCanonicalId(), ControlMessageDto.Companion.toControlMessageDto(message), userGroupIds);
    }

    private void enqueueCreateNodeTask(Id nodeId) {
        this.pubSubOperationKafkaProducer.send(nodeId, (PubSubOperation)PubSubOperation.CreateNode.INSTANCE);
    }

    private void enqueueDeleteNodeTask(Id nodeId) {
        this.pubSubOperationKafkaProducer.send(nodeId, (PubSubOperation)PubSubOperation.DeleteNode.INSTANCE);
    }

    private void enqueueSubscribeTask(Id nodeId, Set<ProfileId> subscriber) {
        if (subscriber.isEmpty()) {
            return;
        }
        CollectionsKt.chunked((Iterable)subscriber, (int)200, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void enqueueUnsubscribeTask(Id nodeId, Set<ProfileId> subscriber) {
        if (subscriber.isEmpty()) {
            return;
        }
        CollectionsKt.chunked((Iterable)subscriber, (int)200, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void enqueuePublishMessage(Id nodeId, ChatMessageId chatMessageId) {
        this.pubSubOperationKafkaProducer.send(nodeId, (PubSubOperation)new PubSubOperation.PublishMessage(chatMessageId));
    }

    private ControlMessage.LoadMessage toControlMessage(SystemMessage $this$toControlMessage) {
        return new ControlMessage.LoadMessage($this$toControlMessage.getChatId(), $this$toControlMessage.getId());
    }

    private ControlMessage.LoadMessage toControlMessage(DeletedMessage $this$toControlMessage) {
        return new ControlMessage.LoadMessage($this$toControlMessage.getChatId(), $this$toControlMessage.getId());
    }

    private static final void clearAndSyncChatNodes$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onChatMessageCreated$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onUserGroupMembersAdded$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void onUserGroupMembersRemoved$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void onChatParticipantsChangedEvent$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void publishGroupChatMessage$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void publishGroupChatMessage$lambda$15(ChatMessageId $chatMessageId) {
        LOG.info("Could not load message with id {} from db while trying to publish message.", (Object)$chatMessageId);
    }

    private static final NotFoundException getUserMessageDto$lambda$17$lambda$16() {
        return new NotFoundException("Cited Message could not be found");
    }

    public static final /* synthetic */ void access$sendChatMessage(XmppService $this, Set recipients, ChatMessage message) {
        $this.sendChatMessage(recipients, message);
    }

    public static final /* synthetic */ ChatParticipantService access$getChatParticipantService$p(XmppService $this) {
        return $this.chatParticipantService;
    }

    public static final /* synthetic */ void access$enqueuePublishMessage(XmppService $this, Id nodeId, ChatMessageId chatMessageId) {
        $this.enqueuePublishMessage(nodeId, chatMessageId);
    }

    public static final /* synthetic */ void access$enqueueSubscribeTask(XmppService $this, Id nodeId, Set subscriber) {
        $this.enqueueSubscribeTask(nodeId, subscriber);
    }

    public static final /* synthetic */ void access$enqueueUnsubscribeTask(XmppService $this, Id nodeId, Set subscriber) {
        $this.enqueueUnsubscribeTask(nodeId, subscriber);
    }

    public static final /* synthetic */ XmppRestApiService access$getXmppRestApiService$p(XmppService $this) {
        return $this.xmppRestApiService;
    }

    public static final /* synthetic */ UserMessageDto access$getUserMessageDto(XmppService $this, UserMessage chatMessage) {
        return $this.getUserMessageDto(chatMessage);
    }

    public static final /* synthetic */ void access$publishControlMessageToUserGroupsAndChat(XmppService $this, Set userGroupIds, ChatId chatId, ControlMessage message) {
        $this.publishControlMessageToUserGroupsAndChat(userGroupIds, chatId, message);
    }

    public static final /* synthetic */ PubSubOperationKafkaProducer access$getPubSubOperationKafkaProducer$p(XmppService $this) {
        return $this.pubSubOperationKafkaProducer;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$enqueueDeleteNodeTask(XmppService $this, Id nodeId) {
        $this.enqueueDeleteNodeTask(nodeId);
    }

    public static final /* synthetic */ void access$enqueueCreateNodeTask(XmppService $this, Id nodeId) {
        $this.enqueueCreateNodeTask(nodeId);
    }

    public static final /* synthetic */ void access$sendControlMessageToDirectParticipants(XmppService $this, Set recipients, ControlMessage message) {
        $this.sendControlMessageToDirectParticipants(recipients, message);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

