/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.kafka.model.KafkaProfile;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ProfileStatus;
import de.justsoftware.chat.persistence.ProfileRepository;
import de.justsoftware.chat.persistence.model.DbProfile;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0012J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\rH\u0012J!\u0010\u001a\u001a\u00020\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0011\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0017J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u001dH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/chat/business/ProfileService;", "", "profileRepository", "Lde/justsoftware/chat/persistence/ProfileRepository;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/persistence/ProfileRepository;Lde/justsoftware/chat/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;)V", "findByIds", "", "Lde/justsoftware/chat/model/ProfileId;", "Lde/justsoftware/chat/business/model/Profile;", "profileIds", "", "fireUpdateEventAfterCommit", "", "savedProfile", "oldStatus", "Lde/justsoftware/chat/model/ProfileStatus;", "getById", "id", "getCurrentStatus", "profileId", "onProfilesUpdate", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "Lde/justsoftware/chat/kafka/model/KafkaProfile;", "onProfilesUpdate$chat_service", "save", "profile", "updateImageUrl", "imageUrl", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nProfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileService.kt\nde/justsoftware/chat/business/ProfileService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,115:1\n1#2:116\n1549#3:117\n1620#3,3:118\n1360#3:121\n1446#3,5:122\n1549#3:127\n1620#3,3:128\n1194#3,2:131\n1222#3,4:133\n1855#3,2:137\n9#4:139\n8#4,3:140\n*S KotlinDebug\n*F\n+ 1 ProfileService.kt\nde/justsoftware/chat/business/ProfileService\n*L\n42#1:117\n42#1:118,3\n44#1:121\n44#1:122,5\n45#1:127\n45#1:128,3\n46#1:131,2\n46#1:133,4\n71#1:137,2\n112#1:139\n112#1:140,3\n*E\n"})
public class ProfileService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ProfileRepository profileRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final Clock clock;
    @NotNull
    public static final String PERSONS_TOPIC = "just.persons";
    @NotNull
    private static final Logger LOG;

    public ProfileService(@NotNull ProfileRepository profileRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.profileRepository = profileRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.clock = clock;
    }

    @Transactional
    @NotNull
    public Profile save(@NotNull Profile profile) {
        Profile profile2;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        ProfileStatus oldStatus = this.getCurrentStatus(profile.getId());
        Object object = this.profileRepository.save((Object)DbProfile.Companion.toDbProfile(profile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"profileRepository\n      \u2026ve(profile.toDbProfile())");
        Profile savedProfile = profile2 = DbProfile.Companion.toProfile((DbProfile)object);
        boolean bl = false;
        this.fireUpdateEventAfterCommit(savedProfile, oldStatus);
        return profile2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Profile> findByIds(@NotNull Set<ProfileId> profileIds) {
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable $this$map$iv = profileIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.toCanonicalId());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ProfileRepository $i$f$map22 = this.profileRepository;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable p0 = (Iterable)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findAllById(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        Iterable $i$f$flatMap22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (DbProfile)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            object.add(DbProfile.Companion.toProfile((DbProfile)it));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Profile bl = (Profile)element$iv$iv;
            object = destination$iv$iv22;
            boolean bl2 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv22;
    }

    @NotNull
    public Profile getById(@NotNull ProfileId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Profile profile = this.profileRepository.findById((Object)id.toCanonicalId()).map(arg_0 -> ProfileService.getById$lambda$4((Function1)getById.1.INSTANCE, arg_0)).orElseThrow(() -> ProfileService.getById$lambda$5(id));
        Intrinsics.checkNotNullExpressionValue((Object)profile, (String)"profileRepository\n      \u2026d $id does not exist.\") }");
        return profile;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Profile updateImageUrl(@NotNull ProfileId id, @NotNull String imageUrl) {
        Profile profile;
        void dbProfile;
        DbProfile $this$updateImageUrl_u24lambda_u247;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Object t = this.profileRepository.findById((Object)id.toCanonicalId()).orElseThrow(() -> ProfileService.updateImageUrl$lambda$6(id));
        DbProfile dbProfile2 = (DbProfile)t;
        DbProfile.Companion companion = DbProfile.Companion;
        boolean bl = false;
        $this$updateImageUrl_u24lambda_u247.setImageUrl(imageUrl);
        $this$updateImageUrl_u24lambda_u247 = (DbProfile)t;
        boolean bl2 = false;
        DbProfile dbProfile3 = (DbProfile)this.profileRepository.save((Object)dbProfile);
        Intrinsics.checkNotNullExpressionValue((Object)dbProfile3, (String)"profileRepository\n      \u2026ository.save(dbProfile) }");
        Profile savedProfile = profile = companion.toProfile(dbProfile3);
        boolean bl3 = false;
        this.fireUpdateEventAfterCommit(savedProfile, savedProfile.getStatus());
        return profile;
    }

    @KafkaListener(id="profileConsumer", containerFactory="profileConsumerFactory", topics={"just.persons"}, idIsGroup=false)
    public void onProfilesUpdate$chat_service(@NotNull ConsumerRecords<String, KafkaProfile> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                KafkaProfile kafkaProfile = (KafkaProfile)record.value();
                Intrinsics.checkNotNullExpressionValue((Object)kafkaProfile, (String)"kafkaProfile");
                this.save(KafkaProfile.Companion.toProfile(kafkaProfile, this.clock));
            }
            catch (RuntimeException e) {
                LOG.error("Failed to save or update profile with id = " + ((KafkaProfile)record.value()).getId() + ". Skip this record.", (Throwable)e);
            }
        }
    }

    private ProfileStatus getCurrentStatus(ProfileId profileId) {
        return this.profileRepository.findById((Object)profileId.toCanonicalId()).map(arg_0 -> ProfileService.getCurrentStatus$lambda$11((Function1)getCurrentStatus.1.INSTANCE, arg_0)).orElse(null);
    }

    private void fireUpdateEventAfterCommit(Profile savedProfile, ProfileStatus oldStatus) {
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static final Profile getById$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Profile)$tmp0.invoke(p0);
    }

    private static final NotFoundException getById$lambda$5(ProfileId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("User with id " + $id + " does not exist.");
    }

    private static final NotFoundException updateImageUrl$lambda$6(ProfileId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("User with id " + $id + " does not exist.");
    }

    private static final ProfileStatus getCurrentStatus$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProfileStatus)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ProfileService $this) {
        return $this.applicationEventPublisher;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

