/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatCleanupService;
import de.justsoftware.chat.business.PermissionService;
import de.justsoftware.chat.config.ChatConfigProperties;
import de.justsoftware.chat.kafka.DriveItemIdProducer;
import de.justsoftware.chat.persistence.ChatDeletionRepository;
import de.justsoftware.chat.persistence.ChatMessageRepository;
import de.justsoftware.chat.persistence.ChatParticipantRepository;
import de.justsoftware.chat.persistence.ChatReadDateRepository;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.ChatSettingsRepository;
import de.justsoftware.chat.persistence.RemovedParticipantProfileForSyncRepository;
import de.justsoftware.chat.persistence.model.DbChatDeletion;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/chat/business/ChatCleanupService;", "", "chatParticipantRepository", "Lde/justsoftware/chat/persistence/ChatParticipantRepository;", "chatDeletionRepository", "Lde/justsoftware/chat/persistence/ChatDeletionRepository;", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "chatReadDateRepository", "Lde/justsoftware/chat/persistence/ChatReadDateRepository;", "chatMessageRepository", "Lde/justsoftware/chat/persistence/ChatMessageRepository;", "chatSettingsRepository", "Lde/justsoftware/chat/persistence/ChatSettingsRepository;", "chatRemovedParticipantProfileForSyncRepository", "Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;", "permissionService", "Lde/justsoftware/chat/business/PermissionService;", "driveItemIdProducer", "Lde/justsoftware/chat/kafka/DriveItemIdProducer;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "chatConfigProperties", "Lde/justsoftware/chat/config/ChatConfigProperties;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/persistence/ChatParticipantRepository;Lde/justsoftware/chat/persistence/ChatDeletionRepository;Lde/justsoftware/chat/persistence/ChatRepository;Lde/justsoftware/chat/persistence/ChatReadDateRepository;Lde/justsoftware/chat/persistence/ChatMessageRepository;Lde/justsoftware/chat/persistence/ChatSettingsRepository;Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;Lde/justsoftware/chat/business/PermissionService;Lde/justsoftware/chat/kafka/DriveItemIdProducer;Lde/justsoftware/chat/util/TransactionUtils;Lde/justsoftware/chat/config/ChatConfigProperties;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;)V", "cleanupChats", "", "abandonedBefore", "Ljava/time/Instant;", "startChatCleanup", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatCleanupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCleanupService.kt\nde/justsoftware/chat/business/ChatCleanupService\n+ 2 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,116:1\n7#2:117\n1620#3,3:118\n1549#3:121\n1620#3,3:122\n9#4:125\n8#4,3:126\n*S KotlinDebug\n*F\n+ 1 ChatCleanupService.kt\nde/justsoftware/chat/business/ChatCleanupService\n*L\n59#1:117\n59#1:118,3\n62#1:121\n62#1:122,3\n113#1:125\n113#1:126,3\n*E\n"})
public class ChatCleanupService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ChatParticipantRepository chatParticipantRepository;
    @NotNull
    private final ChatDeletionRepository chatDeletionRepository;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final ChatReadDateRepository chatReadDateRepository;
    @NotNull
    private final ChatMessageRepository chatMessageRepository;
    @NotNull
    private final ChatSettingsRepository chatSettingsRepository;
    @NotNull
    private final RemovedParticipantProfileForSyncRepository chatRemovedParticipantProfileForSyncRepository;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final DriveItemIdProducer driveItemIdProducer;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ChatConfigProperties chatConfigProperties;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Logger LOG;

    public ChatCleanupService(@NotNull ChatParticipantRepository chatParticipantRepository, @NotNull ChatDeletionRepository chatDeletionRepository, @NotNull ChatRepository chatRepository, @NotNull ChatReadDateRepository chatReadDateRepository, @NotNull ChatMessageRepository chatMessageRepository, @NotNull ChatSettingsRepository chatSettingsRepository, @NotNull RemovedParticipantProfileForSyncRepository chatRemovedParticipantProfileForSyncRepository, @NotNull PermissionService permissionService, @NotNull DriveItemIdProducer driveItemIdProducer, @NotNull TransactionUtils transactionUtils, @NotNull ChatConfigProperties chatConfigProperties, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatParticipantRepository, (String)"chatParticipantRepository");
        Intrinsics.checkNotNullParameter((Object)chatDeletionRepository, (String)"chatDeletionRepository");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)chatReadDateRepository, (String)"chatReadDateRepository");
        Intrinsics.checkNotNullParameter((Object)chatMessageRepository, (String)"chatMessageRepository");
        Intrinsics.checkNotNullParameter((Object)chatSettingsRepository, (String)"chatSettingsRepository");
        Intrinsics.checkNotNullParameter((Object)chatRemovedParticipantProfileForSyncRepository, (String)"chatRemovedParticipantProfileForSyncRepository");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)driveItemIdProducer, (String)"driveItemIdProducer");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)chatConfigProperties, (String)"chatConfigProperties");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatParticipantRepository = chatParticipantRepository;
        this.chatDeletionRepository = chatDeletionRepository;
        this.chatRepository = chatRepository;
        this.chatReadDateRepository = chatReadDateRepository;
        this.chatMessageRepository = chatMessageRepository;
        this.chatSettingsRepository = chatSettingsRepository;
        this.chatRemovedParticipantProfileForSyncRepository = chatRemovedParticipantProfileForSyncRepository;
        this.permissionService = permissionService;
        this.driveItemIdProducer = driveItemIdProducer;
        this.transactionUtils = transactionUtils;
        this.chatConfigProperties = chatConfigProperties;
        this.applicationEventPublisher = applicationEventPublisher;
        this.clock = clock;
    }

    @Scheduled(fixedRate=60L, initialDelay=1L, timeUnit=TimeUnit.MINUTES)
    @Transactional
    public void startChatCleanup() {
        long abandonedForSeconds = TimeUnit.SECONDS.convert(this.chatConfigProperties.getCleanupAfter());
        if (abandonedForSeconds <= 0L) {
            LOG.info("Cleanup of chats is deactivated via Superoperty");
            return;
        }
        LOG.info("Starting chat cleanup job with 'abandonedForSeconds = {}'...", (Object)abandonedForSeconds);
        Instant instant = this.clock.instant().minusSeconds(abandonedForSeconds);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant().minusSeconds(abandonedForSeconds)");
        this.cleanupChats(instant);
        LOG.info("Chat cleanup job finished.");
    }

    /*
     * WARNING - void declaration
     */
    public void cleanupChats(@NotNull Instant abandonedBefore) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)abandonedBefore, (String)"abandonedBefore");
        Iterable $this$mapToSet$iv = this.chatDeletionRepository.findByCreatedAtBefore(abandonedBefore);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DbChatDeletion dbChatDeletion = (DbChatDeletion)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChatId());
        }
        Set deletedChats = (Set)destination$iv$iv;
        Set orphanedChats = CollectionsKt.toSet((Iterable)this.chatParticipantRepository.findOrphanedChatsWithSyncDateBefore(abandonedBefore));
        $this$mapTo$iv$iv2 = this.chatDeletionRepository.findByChatIds((Iterable)orphanedChats);
        collection = orphanedChats;
        boolean $i$f$map = false;
        void $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbChatDeletion dbChatDeletion = (DbChatDeletion)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add(it.getChatId());
        }
        Set undeletedOrphanedChats = SetsKt.minus((Set)collection, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        Set chatIdsToCleanup = SetsKt.plus((Set)deletedChats, (Iterable)undeletedOrphanedChats);
        if (!((Collection)deletedChats).isEmpty()) {
            LOG.info("Cleaning up deleted chats {}", (Object)deletedChats);
        }
        if (!((Collection)undeletedOrphanedChats).isEmpty()) {
            LOG.info("Cleaning up orphaned chats {}", (Object)undeletedOrphanedChats);
        }
        this.chatDeletionRepository.deleteByChatIds((Iterable)chatIdsToCleanup);
        this.chatParticipantRepository.deleteParticipantFromDeletedChatIds((Iterable)chatIdsToCleanup);
        this.chatParticipantRepository.deleteByChatIds((Iterable)chatIdsToCleanup);
        this.chatReadDateRepository.deleteByChatIds((Iterable)chatIdsToCleanup);
        this.chatRepository.deleteLastMessageIdForChatIds((Iterable)chatIdsToCleanup);
        this.chatMessageRepository.deleteByChatIds((Iterable)chatIdsToCleanup);
        this.chatSettingsRepository.deleteByChatIds((Iterable)chatIdsToCleanup);
        this.chatRemovedParticipantProfileForSyncRepository.deleteByChatIds((Iterable)chatIdsToCleanup);
        this.chatRepository.deleteAllById((Iterable)chatIdsToCleanup);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ChatCleanupService $this) {
        return $this.applicationEventPublisher;
    }

    public static final /* synthetic */ PermissionService access$getPermissionService$p(ChatCleanupService $this) {
        return $this.permissionService;
    }

    public static final /* synthetic */ DriveItemIdProducer access$getDriveItemIdProducer$p(ChatCleanupService $this) {
        return $this.driveItemIdProducer;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

