/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.SaveChatMessageDto;
import de.justsoftware.chat.application.model.SavePersonMentionDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChatLocalizationService;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.LoadDirection;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.PagingUtilsKt;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0016JF\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/chat/application/ChatMessageApplicationService;", "", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "chatLocalizationService", "Lde/justsoftware/chat/business/ChatLocalizationService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ChatLocalizationService;Lde/justsoftware/chat/business/ProfileService;Ljava/time/Clock;)V", "createChatMessage", "Lde/justsoftware/chat/application/model/ChatMessageDto;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "saveChatMessageDto", "Lde/justsoftware/chat/application/model/SaveChatMessageDto;", "attachments", "", "Lorg/springframework/web/multipart/MultipartFile;", "savePersonMentionDtos", "Lde/justsoftware/chat/application/model/SavePersonMentionDto;", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "deleteChatMessage", "", "chatMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "getChatMessage", "includeCitation", "", "getMessages", "Lorg/springframework/data/domain/Page;", "offsetMessageId", "limit", "", "loadDirection", "Lde/justsoftware/chat/business/LoadDirection;", "includeOffsetMessage", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageApplicationService.kt\nde/justsoftware/chat/application/ChatMessageApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n*L\n1#1,149:1\n1549#2:150\n1620#2,3:151\n1611#2:156\n1855#2:157\n1856#2:159\n1612#2:160\n1611#2:162\n1855#2:163\n1856#2:165\n1612#2:166\n1#3:154\n1#3:158\n1#3:164\n10#4:155\n10#4:161\n*S KotlinDebug\n*F\n+ 1 ChatMessageApplicationService.kt\nde/justsoftware/chat/application/ChatMessageApplicationService\n*L\n47#1:150\n47#1:151,3\n100#1:156\n100#1:157\n100#1:159\n100#1:160\n103#1:162\n103#1:163\n103#1:165\n103#1:166\n100#1:158\n103#1:164\n100#1:155\n103#1:161\n*E\n"})
public class ChatMessageApplicationService {
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ChatLocalizationService chatLocalizationService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final Clock clock;

    public ChatMessageApplicationService(@NotNull ChatMessageService chatMessageService, @NotNull ChatLocalizationService chatLocalizationService, @NotNull ProfileService profileService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)chatLocalizationService, (String)"chatLocalizationService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatMessageService = chatMessageService;
        this.chatLocalizationService = chatLocalizationService;
        this.profileService = profileService;
        this.clock = clock;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ChatMessageDto createChatMessage(@NotNull ChatId chatId, @NotNull SaveChatMessageDto saveChatMessageDto, @NotNull List<? extends MultipartFile> attachments, @NotNull List<SavePersonMentionDto> savePersonMentionDtos, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException, NotFoundException {
        ChatMessageDto chatMessageDto;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)saveChatMessageDto, (String)"saveChatMessageDto");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter(savePersonMentionDtos, (String)"savePersonMentionDtos");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteChat(chatId);
        Iterable $this$map$iv = savePersonMentionDtos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SavePersonMentionDto savePersonMentionDto = (SavePersonMentionDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SavePersonMentionDto.Companion.toPersonMention((SavePersonMentionDto)it, this.clock));
        }
        List personMentions = (List)destination$iv$iv;
        ChatMessage chatMessage = this.chatMessageService.create((ChatMessage)SaveChatMessageDto.Companion.toUserMessage(saveChatMessageDto, chatId, authContext.getProfileId(), this.clock, personMentions), attachments);
        ChatMessageId chatMessageId = saveChatMessageDto.getCitedMessageId();
        if (chatMessageId != null) {
            ChatMessageId it = chatMessageId;
            boolean bl = false;
            chatMessageDto = ChatMessageApplicationService.getChatMessage$default((ChatMessageApplicationService)this, (ChatId)chatId, (ChatMessageId)it, (AuthorizationContext)authContext, (boolean)false, (int)8, null);
        } else {
            chatMessageDto = null;
        }
        ChatMessageDto citation = chatMessageDto;
        return ChatMessageDto.Companion.toChatMessageDto(chatMessage, ProfileDto.Companion.toProfileDto(this.profileService.getById(chatMessage.getAuthor())), this.chatLocalizationService.localizeMessage(chatMessage, authContext), citation);
    }

    public void deleteChatMessage(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatMessageService.delete(chatMessageId, authContext.getProfileId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ChatMessageDto> getMessages(@NotNull ChatId chatId, @Nullable ChatMessageId offsetMessageId, int limit, @NotNull LoadDirection loadDirection, boolean includeOffsetMessage, @NotNull AuthorizationContext authContext) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullToSet$iv2;
        ChatMessage offsetMessage;
        Object p0;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        ChatMessageId chatMessageId = offsetMessageId;
        if (chatMessageId != null) {
            ChatMessageId chatMessageId2 = chatMessageId;
            ChatMessageService chatMessageService = this.chatMessageService;
            p0 = chatMessageId2;
            boolean bl = false;
            v1 = chatMessageService.getById(p0);
        } else {
            v1 = offsetMessage = null;
        }
        if (offsetMessage != null && !Intrinsics.areEqual((Object)offsetMessage.getChatId(), (Object)chatId)) {
            throw new NotFoundException("Message " + offsetMessageId + " is not found in chat " + chatId);
        }
        ChatMessage chatMessage = offsetMessage;
        Page messages2 = ChatMessageService.getMessages$default((ChatMessageService)this.chatMessageService, (ChatId)chatId, (int)limit, (LoadDirection)loadDirection, (Instant)(chatMessage != null ? chatMessage.getCreatedAt() : null), null, (int)16, null);
        if (includeOffsetMessage && offsetMessage != null) {
            messages2 = PagingUtilsKt.addFirst((Page)messages2, (Object)offsetMessage);
        }
        List list = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"messages.content");
        p0 = list;
        ChatMessageService chatMessageService = this.chatMessageService;
        boolean $i$f$mapNotNullToSet22 = false;
        void var12_14 = $this$mapNotNullToSet$iv2;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv2));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChatMessageId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatMessage it = (ChatMessage)element$iv$iv;
            boolean bl2 = false;
            UserMessage userMessage = it instanceof UserMessage ? (UserMessage)it : null;
            if ((userMessage != null ? userMessage.getCitedMessageId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map citations = chatMessageService.findByIds((Set)destination$iv$iv);
        List list2 = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"messages.content");
        Iterable $i$f$mapNotNullToSet22 = CollectionsKt.plus((Collection)list2, (Iterable)citations.values());
        chatMessageService = this.profileService;
        boolean $i$f$mapNotNullToSet = false;
        destination$iv$iv = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ChatMessage p02 = (ChatMessage)element$iv$iv;
            boolean bl4 = false;
            if (p02.getAuthor() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map profiles2 = chatMessageService.findByIds((Set)destination$iv$iv2);
        Page page = messages2.map(arg_0 -> ChatMessageApplicationService.getMessages$lambda$4((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"fun getMessages(\n       \u2026    )\n            }\n    }");
        return page;
    }

    public static /* synthetic */ Page getMessages$default(ChatMessageApplicationService chatMessageApplicationService, ChatId chatId, ChatMessageId chatMessageId, int n, LoadDirection loadDirection, boolean bl, AuthorizationContext authorizationContext, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessages");
        }
        if ((n2 & 2) != 0) {
            chatMessageId = null;
        }
        if ((n2 & 8) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        return chatMessageApplicationService.getMessages(chatId, chatMessageId, n, loadDirection, bl, authorizationContext);
    }

    @NotNull
    public ChatMessageDto getChatMessage(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext, boolean includeCitation) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        ChatMessageDto chatMessageDto = this.chatMessageService.findById(chatMessageId).filter(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda$5((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).map(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).orElseThrow(() -> ChatMessageApplicationService.getChatMessage$lambda$7(chatMessageId, chatId));
        Intrinsics.checkNotNullExpressionValue((Object)chatMessageDto, (String)"fun getChatMessage(\n    \u2026or chat $chatId\") }\n    }");
        return chatMessageDto;
    }

    public static /* synthetic */ ChatMessageDto getChatMessage$default(ChatMessageApplicationService chatMessageApplicationService, ChatId chatId, ChatMessageId chatMessageId, AuthorizationContext authorizationContext, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessage");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return chatMessageApplicationService.getChatMessage(chatId, chatMessageId, authorizationContext, bl);
    }

    private static final ChatMessageDto getMessages$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessageDto)$tmp0.invoke(p0);
    }

    private static final boolean getChatMessage$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ChatMessageDto getChatMessage$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessageDto)$tmp0.invoke(p0);
    }

    private static final NotFoundException getChatMessage$lambda$7(ChatMessageId $chatMessageId, ChatId $chatId) {
        Intrinsics.checkNotNullParameter((Object)$chatMessageId, (String)"$chatMessageId");
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        return new NotFoundException("ChatMessage with id " + $chatMessageId + " does not exist for chat " + $chatId);
    }

    public static final /* synthetic */ ChatLocalizationService access$getChatLocalizationService$p(ChatMessageApplicationService $this) {
        return $this.chatLocalizationService;
    }

    public static final /* synthetic */ ProfileService access$getProfileService$p(ChatMessageApplicationService $this) {
        return $this.profileService;
    }
}

