/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.browserpushservice.model;

import de.justsoftware.browserpushservice.exceptions.WrongFormatException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileId {
    private final long _profileId;

    public ProfileId(String profileId) {
        this._profileId = this.fromString(profileId);
    }

    private long fromString(String profileId) {
        String exceptionMessage = "Profile ID was in wrong format.";
        String[] parts = profileId.split(",");
        if (parts.length == 2 && parts[0].equals("PROFILE")) {
            try {
                return Long.parseLong(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new WrongFormatException("Profile ID was in wrong format.");
            }
        }
        throw new WrongFormatException("Profile ID was in wrong format.");
    }

    public long getProfileId() {
        return this._profileId;
    }

    @Nonnull
    public String asString() {
        return "PROFILE," + String.valueOf(this._profileId);
    }
}

