/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher.producer;

import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.kafka.publisher.model.KafkaPublishOperation;
import de.justsoftware.admin.kafka.publisher.producer.TenantProducer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minidev.json.JSONObject;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0012J<\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0012J5\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0010\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;", "", "kafkaTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "", "log", "Lorg/slf4j/Logger;", "(Lorg/springframework/kafka/core/KafkaTemplate;Lorg/slf4j/Logger;)V", "generateTheme", "", "allAppSettings", "", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "getTenantInformation", "tenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "tenantInvitationCode", "publish", "Lde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation;", "", "publish$admin_service", "publishDeletedTenant", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "Companion", "admin-service"})
@SourceDebugExtension(value={"SMAP\nTenantProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantProducer.kt\nde/justsoftware/admin/kafka/publisher/producer/TenantProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1179#2,2:105\n1253#2,4:107\n*S KotlinDebug\n*F\n+ 1 TenantProducer.kt\nde/justsoftware/admin/kafka/publisher/producer/TenantProducer\n*L\n91#1:105,2\n91#1:107,4\n*E\n"})
public class TenantProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaTemplate<String, Object> kafkaTemplate;
    @NotNull
    private final Logger log;
    @NotNull
    private static final String TENANT_TOPIC = "just.tenants";

    public TenantProducer(@NotNull KafkaTemplate<String, Object> kafkaTemplate, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter(kafkaTemplate, (String)"kafkaTemplate");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.kafkaTemplate = kafkaTemplate;
        this.log = log;
    }

    public /* synthetic */ TenantProducer(KafkaTemplate kafkaTemplate, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Logger logger2 = LoggerFactory.getLogger(TenantProducer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger = logger2;
        }
        this(kafkaTemplate, logger);
    }

    @NotNull
    public KafkaPublishOperation publishDeletedTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.log.debug("Sending key '" + tenantId + "' to kafka topic just.tenants with null message.");
        CompletableFuture completableFuture = this.kafkaTemplate.send(TENANT_TOPIC, (Object)tenantId.toTypedString(), null);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"send(...)");
        CompletableFuture listenable = completableFuture;
        return new KafkaPublishOperation(listenable);
    }

    @NotNull
    public KafkaPublishOperation publish$admin_service(@NotNull Tenant tenant, @NotNull Collection<CoreAppSettings> allAppSettings, @NotNull TenantSettings tenantSettings, @Nullable String tenantInvitationCode) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(allAppSettings, (String)"allAppSettings");
        Intrinsics.checkNotNullParameter((Object)tenantSettings, (String)"tenantSettings");
        String tenantItemId = tenant.getId().toTypedString();
        this.log.debug("Sending tenant to Kafka topic just.tenants with the message : " + tenantItemId + ")");
        Map tenantInformation = this.getTenantInformation(CollectionsKt.toSet((Iterable)allAppSettings), tenantSettings, tenant, tenantInvitationCode);
        CompletableFuture completableFuture = this.kafkaTemplate.send(new ProducerRecord(TENANT_TOPIC, (Object)tenantItemId, (Object)new JSONObject(tenantInformation).toString()));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"send(...)");
        CompletableFuture listenableFuture = completableFuture;
        return new KafkaPublishOperation(listenableFuture);
    }

    private Map<String, Object> getTenantInformation(Set<CoreAppSettings> allAppSettings, TenantSettings tenantSettings, Tenant tenant, String tenantInvitationCode) {
        JSONObject tenantTheme = new JSONObject(this.generateTheme(allAppSettings, tenantSettings));
        Object[] objectArray = new Pair[]{tenantInvitationCode != null ? TuplesKt.to((Object)"invitationCode", (Object)tenantInvitationCode) : null, tenantSettings.getDeeplKey() != null ? TuplesKt.to((Object)"deeplKey", (Object)tenantSettings.getDeeplKey()) : null, TuplesKt.to((Object)"id", (Object)tenant.getId().toTypedString()), TuplesKt.to((Object)"name", (Object)tenant.getName()), TuplesKt.to((Object)"theme", (Object)tenantTheme)};
        return MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> generateTheme(Set<CoreAppSettings> allAppSettings, TenantSettings tenantSettings) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object object = allAppSettings;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            CoreAppSettings it = (CoreAppSettings)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)("APP_COLOR_" + it.getApp().name()), (Object)it.getAppColor().toString());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map tenantTheme = MapsKt.toMutableMap((Map)destination$iv$iv);
        tenantTheme.put("GLOBAL_HIGHLIGHT_COLOR", tenantSettings.getGlobalHighlightColor().toString());
        object = tenantTheme;
        String string = "TENANT_LOGO_ID";
        Object object2 = tenantSettings.getLogoId();
        if (object2 == null || (object2 = object2.getValue()) == null || (object2 = ((UUID)object2).toString()) == null) {
            object2 = "";
        }
        Object object3 = object2;
        object.put(string, object3);
        return tenantTheme;
    }
}

