/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.consumer;

import de.justsoftware.admin.application.kafka.KafkaConsumerApplicationService;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.kafka.consumer.KafkaConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00022\u0010\b\u0001\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/admin/kafka/consumer/KafkaProfileTenantConsumer;", "Lde/justsoftware/admin/kafka/consumer/KafkaConsumer;", "Lde/justsoftware/admin/id/ProfileId;", "", "Lde/justsoftware/admin/id/TenantId;", "kafkaConsumerApplicationService", "Lde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService;", "(Lde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "listen", "", "key", "payload", "(Lde/justsoftware/admin/id/ProfileId;[Lde/justsoftware/admin/id/TenantId;)V", "admin-service"})
public class KafkaProfileTenantConsumer
implements KafkaConsumer<ProfileId, TenantId[]> {
    @NotNull
    private final KafkaConsumerApplicationService kafkaConsumerApplicationService;
    private final Logger log;

    public KafkaProfileTenantConsumer(@NotNull KafkaConsumerApplicationService kafkaConsumerApplicationService) {
        Intrinsics.checkNotNullParameter((Object)kafkaConsumerApplicationService, (String)"kafkaConsumerApplicationService");
        this.kafkaConsumerApplicationService = kafkaConsumerApplicationService;
        this.log = LoggerFactory.getLogger(KafkaProfileTenantConsumer.class);
    }

    @KafkaListener(containerFactory="tenantProfileListenerContainerFactory", topics={"just.persons.tenantIds"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull ProfileId key, @Payload(required=false) @Nullable TenantId[] payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (payload == null) {
            this.kafkaConsumerApplicationService.deleteProfileTenantRelation(key);
        } else if (payload.length == 1) {
            this.kafkaConsumerApplicationService.saveProfileTenantRelation(key, payload[0]);
        } else {
            this.log.error("Could not deserialize payload: {} to TenantId", (Object)payload);
        }
    }
}

