BEGIN;

UPDATE conversation AS c
SET title = titles.title
FROM (
	SELECT tmp.conversation_id as id, array_to_string(array_agg(tmp.name), ', ') as title
	FROM (
	    SELECT cp.conversation_id, p.firstname || ' ' || p.surname AS name 
	    FROM person p 
	    JOIN conversation_participant cp ON (cp.participant_id = p.id) 
	    JOIN conversation c ON (cp.conversation_id = c.id)
        WHERE c.type = 'MULTI_USER_CHAT'
        AND (trim(both FROM c.title) = '' 
           OR c.title IS null)
	    ORDER BY p.surname
	) AS tmp 
	GROUP BY tmp.conversation_id
) AS titles
WHERE c.id = titles.id;

COMMIT;