BEGIN;

-- select simple task status ids
select entity_status.id into new_status from entity_status where status_name = 'NEW' and entity_type= 'SIMPLETASK';
select entity_status.id into done_status from entity_status where status_name = 'DONE' and entity_type= 'SIMPLETASK';

-- remove old process configs
delete from entity_process where start_entity_status_id in (select new_status.id from new_status);
delete from entity_process where start_entity_status_id in (select done_status.id from done_status);

-- add actual simple task process configs
insert into entity_process (id, start_entity_status_id, process_definition, process_trigger, target_entity_status_id)
    select nextval('entity_process_seq'), new_status.id, 'statusChangeUserTask', 'AUTOMATIC', done_status.id from new_status, done_status;
insert into entity_process (id, start_entity_status_id, process_definition, process_trigger, target_entity_status_id)
    select nextval('entity_process_seq'), done_status.id, 'directStatusChange', 'MANUAL', new_status.id from new_status, done_status;

-- remove temp tables
drop table new_status, done_status;

COMMIT;
